/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.BufferedTankAttachment;
import tv.soaryn.xycraft.core.content.attachments.InventoryAttachment;
import tv.soaryn.xycraft.machines.content.attachments.level.ProducerTickSystemLevelAttachment;
import tv.soaryn.xycraft.machines.content.recipes.producers.oretap.OreTapRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.ProducerTickSystem;

public class OreTapTickSystem
extends ProducerTickSystem<OreTapRecipe, OreTapRecipe.Input> {
    public static final Codec<ProducerTickSystemLevelAttachment<OreTapRecipe, OreTapRecipe.Input>> CODEC = RecordCodecBuilder.create(builder -> ProducerTickSystemLevelAttachment.producerGroup(builder).apply((Applicative)builder, (chunkMap, frequency, enabled) -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)chunkMap, (long)frequency, (boolean)enabled, (RecipeType)MachinesRecipeTypes.OreTap.type().get())));
    public static final AttachmentType.Builder<ProducerTickSystemLevelAttachment<OreTapRecipe, OreTapRecipe.Input>> Builder = AttachmentType.builder(() -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(), 10L, true, (RecipeType)MachinesRecipeTypes.OreTap.type().get())).serialize(CODEC);

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        throw new NotImplementedException();
    }

    protected void tickBlocks(ServerLevel level, ProducerTickSystemLevelAttachment<OreTapRecipe, OreTapRecipe.Input> tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        OreTapRecipe recipe = this.getRecipe(level, tickData, (BlockPos)pos, state, currentStep);
        if (recipe == null) {
            return;
        }
        if (recipe.output().left().isPresent()) {
            BufferedTankAttachment data = (BufferedTankAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.Block.BufferedTankData);
            data.Tank.fill(((FluidStack)recipe.output().left().get()).copy(), IFluidHandler.FluidAction.EXECUTE);
        } else if (recipe.output().right().isPresent()) {
            InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.Block.SoarynBoxData);
            ItemHandlerHelper.insertItemStacked((IItemHandler)data.Inventory.asHandler(), (ItemStack)((ItemStack)recipe.output().right().get()), (boolean)false);
        }
    }

    @Override
    public OreTapRecipe.Input getInput(ServerLevel level, ProducerTickSystemLevelAttachment<OreTapRecipe, OreTapRecipe.Input> tickData, BlockPos pos, BlockState state, long currentStep) {
        return () -> level.getBlockState(pos.below());
    }

    @Override
    public long getTimeRequired(OreTapRecipe recipe) {
        return recipe.ticks();
    }

    @NotNull
    protected Supplier<AttachmentType<ProducerTickSystemLevelAttachment<OreTapRecipe, OreTapRecipe.Input>>> getAttachmentType() {
        return MachinesAttachments.System.OreTapSystemData;
    }
}

