/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.xynergy;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyHandler;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNet;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNodeClient;
import tv.soaryn.xycraft.api.content.xynergy.XynergyNet;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.xynergy.Node;
import tv.soaryn.xycraft.machines.content.xynergy.XynergyNetGraphLevelAttachment;
import tv.soaryn.xycraft.machines.network.CBXynergyLaserEdgePacket;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public interface XynergyCapabilityRegistry {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        XynergyCapabilityRegistry.registerNet(event);
        XynergyCapabilityRegistry.registerBlocks(event);
        XynergyCapabilityRegistry.registerItems(event);
    }

    private static void registerBlocks(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK, (level, pos, state, blockEntity, context) -> new IXynergyNode(){

            public long getValue() {
                return -4000L;
            }

            public byte getEdgeLimit() {
                return 16;
            }

            public boolean canConnectTo(IXynergyNode otherNode, BlockPos otherPosition, float distanceSquared, @Nullable Player player) {
                if (distanceSquared > 576.0f) {
                    if (player != null) {
                        player.displayClientMessage((Component)Component.literal((String)"Other node is too far away"), true);
                    }
                    return false;
                }
                boolean isAlongAxisOrDiagonal = MathUtils.isAlongAxisAndDiagonal((Vec3i)pos, (Vec3i)otherPosition);
                if (!isAlongAxisOrDiagonal && player != null) {
                    player.displayClientMessage((Component)Component.literal((String)"Lightning rods must be connected along an axis or diagonal"), true);
                }
                return isAlongAxisOrDiagonal;
            }
        }, new Block[]{Blocks.LIGHTNING_ROD});
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK_CLIENT, (level, pos, state, blockEntity, context) -> new IXynergyNodeClient(){
            private static final Vector3f[] offsets = (Vector3f[])Util.make((Object)new Vector3f[6], array -> Arrays.setAll(array, i -> {
                Vector3f offset = new Vector3f(0.0f, 0.625f, 0.0f);
                Direction dir = Direction.from3DDataValue((int)i);
                Vec3i normal = dir.getNormal();
                return offset.rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
            }));

            public int getColor() {
                return -14496649;
            }

            @NotNull
            public Vector3f getRenderOffset(BlockPos otherNode) {
                Direction dir = ((Direction)level.getBlockState(pos).getValue((Property)LightningRodBlock.FACING)).getOpposite();
                Vector3f offset = new Vector3f(0.0f, 0.65f, 0.0f);
                Vec3i normal = dir.getNormal();
                2.offsets[dir.get3DDataValue()] = offset.rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
                return new Vector3f((Vector3fc)offsets[dir.get3DDataValue()]);
            }

            public boolean hasRenderNode(BlockPos otherNode) {
                return true;
            }
        }, new Block[]{Blocks.LIGHTNING_ROD});
    }

    private static void registerItems(RegisterCapabilitiesEvent event) {
        event.registerItem(CoreCapabilities.XynergyStorage.ITEM, (stack, context) -> new IXynergyHandler(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return maxExtract;
            }

            public int getEnergyStored() {
                return 1000000000;
            }

            public int getMaxEnergyStored() {
                return 1000000000;
            }

            public boolean canReceive() {
                return false;
            }
        }, new ItemLike[]{MachinesContent.Item.CreativeCell});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return maxExtract;
            }

            public int getEnergyStored() {
                return 1000000000;
            }

            public int getMaxEnergyStored() {
                return 1000000000;
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return false;
            }
        }, new ItemLike[]{MachinesContent.Item.CreativeCell});
    }

    private static void registerNet(RegisterCapabilitiesEvent event) {
        XynergyNet.setNet(level -> new IXynergyNet((ServerLevel)level){
            final /* synthetic */ ServerLevel val$level;
            {
                this.val$level = serverLevel;
            }

            public long getEnergy(BlockPos pos) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                Node node = (Node)net.nodeInfoMap.get((Object)pos);
                if (node != null) {
                    return node.NetworkedValue;
                }
                IXynergyNode capNode = (IXynergyNode)this.val$level.getCapability(CoreCapabilities.XynergyNode.BLOCK, pos, null);
                if (capNode == null) {
                    return 0L;
                }
                return capNode.getValue();
            }

            public boolean hasNode(BlockPos pos) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                return net.nodeInfoMap.containsKey((Object)pos);
            }

            public int getEdgeCount(BlockPos pos) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                if (!net.nodeInfoMap.containsKey((Object)pos)) {
                    return 0;
                }
                return net.graph.adjacentNodes((Object)pos).size();
            }

            public boolean add(BlockPos pos, IXynergyNode node) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                if (!net.graph.addNode((Object)pos)) {
                    return false;
                }
                net.nodeInfoMap.put((Object)pos, (Object)new Node(node.getValue(), -1L, node.getPowerType()));
                net.dirtyValues.add((Object)pos);
                ChunkPos chunk = new ChunkPos(pos);
                if (net.chunkMapping.containsKey((Object)chunk)) {
                    ObjectArrayList list = (ObjectArrayList)net.chunkMapping.get((Object)chunk);
                    list.add((Object)pos);
                } else {
                    ObjectArrayList list = new ObjectArrayList();
                    list.add((Object)pos);
                    net.chunkMapping.put((Object)chunk, (Object)list);
                }
                return true;
            }

            public boolean remove(BlockPos pos) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                if (!net.graph.nodes().contains(pos)) {
                    return false;
                }
                Set<BlockPos> edges = Set.copyOf(net.graph.adjacentNodes((Object)pos));
                for (BlockPos altPos : edges) {
                    this.removeEdge(pos, altPos);
                }
                if (!net.graph.removeNode((Object)pos)) {
                    return false;
                }
                net.nodeInfoMap.remove((Object)pos);
                net.dirtyValues.remove((Object)pos);
                ChunkPos chunk = new ChunkPos(pos);
                if (net.chunkMapping.containsKey((Object)chunk)) {
                    ObjectArrayList list = (ObjectArrayList)net.chunkMapping.get((Object)chunk);
                    list.remove((Object)pos);
                }
                return true;
            }

            public boolean addEdge(BlockPos aPos, IXynergyNode aNode, BlockPos bPos, IXynergyNode bNode) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                this.add(aPos, aNode);
                this.add(bPos, bNode);
                boolean addedEdge = net.graph.putEdge((Object)aPos, (Object)bPos);
                if (addedEdge) {
                    net.dirtyValues.add((Object)aPos);
                    net.dirtyValues.add((Object)bPos);
                    XyMachines.Network.broadcast((Packet.ClientBound)new CBXynergyLaserEdgePacket(aPos.asLong(), bPos.asLong(), true));
                    return true;
                }
                return false;
            }

            public void removeEdge(BlockPos aPos, BlockPos bPos) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                boolean removed = net.graph.removeEdge((Object)aPos, (Object)bPos);
                if (net.nodeInfoMap.containsKey((Object)aPos)) {
                    net.dirtyValues.add((Object)aPos);
                }
                if (net.nodeInfoMap.containsKey((Object)bPos)) {
                    net.dirtyValues.add((Object)bPos);
                }
                XyMachines.Network.broadcast((Packet.ClientBound)new CBXynergyLaserEdgePacket(aPos.asLong(), bPos.asLong(), false));
            }

            public boolean areNodesConnected(BlockPos aPos, BlockPos bPos) {
                XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)this.val$level.getData(MachinesAttachments.Level.XynergyNetData);
                return net.graph.hasEdgeConnecting((Object)aPos, (Object)bPos);
            }
        });
    }
}

