/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.events.server;

import com.portingdeadmods.cable_facades.CFConfig;
import com.portingdeadmods.cable_facades.CFMain;
import com.portingdeadmods.cable_facades.content.items.FacadeItem;
import com.portingdeadmods.cable_facades.data.CableFacadeSavedData;
import com.portingdeadmods.cable_facades.data.helper.ChunkFacadeMap;
import com.portingdeadmods.cable_facades.networking.s2c.AddFacadedBlocksPayload;
import com.portingdeadmods.cable_facades.networking.s2c.RemoveFacadedBlocksPayload;
import com.portingdeadmods.cable_facades.registries.CFItemTags;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="cable_facades")
public final class ServerInGameEvents {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().level();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        if (!level.isClientSide() && FacadeUtils.hasFacade((BlockGetter)level, pos)) {
            BlockState facade = FacadeUtils.getFacade((BlockGetter)level, pos);
            FacadeUtils.removeFacade(level, pos);
            if (!player.isCreative() && CFConfig.consumeFacade) {
                ItemStack facadeStack = ((FacadeItem)((Object)CFItems.FACADE.get())).createFacade(facade.getBlock());
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)facadeStack);
            }
            event.setCanceled(true);
        }
        FacadeUtils.updateBlocks(level, pos);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState facadeState;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        if (player.isShiftKeyDown() && hand == InteractionHand.OFF_HAND && player.getItemInHand(InteractionHand.MAIN_HAND).is(CFItemTags.WRENCHES)) {
            event.setCanceled(true);
        }
        if ((facadeState = FacadeUtils.getFacade((BlockGetter)level, pos)) == null || !player.getItemInHand(hand).is(CFItemTags.WRENCHES)) {
            return;
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                FacadeUtils.removeFacade(level, pos);
                if (!player.isCreative() && CFConfig.consumeFacade) {
                    ItemStack facadeStack = ((FacadeItem)((Object)CFItems.FACADE.get())).createFacade(facadeState.getBlock());
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)facadeStack);
                } else {
                    level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            }
        } else if (!level.isClientSide()) {
            if (facadeState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                Direction direction = (Direction)facadeState.getValue((Property)HorizontalDirectionalBlock.FACING);
                BlockState newFacadeState = facadeState;
                if (facadeState.hasProperty((Property)BlockStateProperties.HALF) && direction == Direction.WEST) {
                    Half half = (Half)facadeState.getValue((Property)BlockStateProperties.HALF);
                    newFacadeState = (BlockState)newFacadeState.setValue((Property)BlockStateProperties.HALF, (Comparable)(half == Half.BOTTOM ? Half.TOP : Half.BOTTOM));
                }
                newFacadeState = (BlockState)newFacadeState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction.getClockWise());
                FacadeUtils.removeFacade(level, pos);
                FacadeUtils.addFacade(level, pos, newFacadeState);
            } else if (facadeState.hasProperty((Property)DirectionalBlock.FACING)) {
                Direction direction = (Direction)facadeState.getValue((Property)DirectionalBlock.FACING);
                BlockState newFacadeState = (BlockState)facadeState.setValue((Property)DirectionalBlock.FACING, (Comparable)ServerInGameEvents.rotate(direction));
                FacadeUtils.removeFacade(level, pos);
                FacadeUtils.addFacade(level, pos, newFacadeState);
            } else if (facadeState.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) {
                SlabType slab = (SlabType)facadeState.getValue((Property)BlockStateProperties.SLAB_TYPE);
                BlockState newFacadeState = (BlockState)facadeState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)ServerInGameEvents.nextSlab(slab));
                FacadeUtils.removeFacade(level, pos);
                FacadeUtils.addFacade(level, pos, newFacadeState);
            }
        }
        player.swing(hand);
        ServerInGameEvents.updateBlocks(level, pos);
        event.setCanceled(true);
    }

    public static void updateBlocks(Level level, BlockPos pos) {
        level.getLightEngine().checkBlock(pos);
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 3);
        level.updateNeighborsAt(pos, state.getBlock());
    }

    @SubscribeEvent
    public static void loadChunk(ChunkWatchEvent.Sent event) {
        ChunkPos chunkPos = event.getPos();
        ServerPlayer serverPlayer = event.getPlayer();
        ServerLevel serverLevel = event.getLevel();
        CableFacadeSavedData data = CableFacadeSavedData.get(serverLevel);
        ChunkFacadeMap facadeMapForChunk = data.getFacadeMapForChunk(chunkPos);
        if (facadeMapForChunk != null) {
            CFMain.LOGGER.debug("Server Facaded Blocks: {}", facadeMapForChunk.getChunkMap());
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)new AddFacadedBlocksPayload(chunkPos, facadeMapForChunk.getChunkMap()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void unloadChunk(ChunkWatchEvent.UnWatch event) {
        ChunkPos chunkPos = event.getPos();
        ServerPlayer serverPlayer = event.getPlayer();
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new RemoveFacadedBlocksPayload(chunkPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static Direction rotate(Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> Direction.NORTH;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.NORTH -> Direction.EAST;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.UP -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            default -> direction;
        };
    }

    private static SlabType nextSlab(SlabType slab) {
        return switch (slab) {
            default -> throw new MatchException(null, null);
            case SlabType.BOTTOM -> SlabType.TOP;
            case SlabType.TOP -> SlabType.DOUBLE;
            case SlabType.DOUBLE -> SlabType.BOTTOM;
        };
    }
}

