/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.eventslib.util;

import com.sts15.eventslib.events.MobEffectAppliedEvent;
import com.sts15.eventslib.events.MobEffectExpiredEvent;
import com.sts15.eventslib.events.MobEffectRemovedEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;

public class DebugEffectEventHandler {
    public static void register() {
        NeoForge.EVENT_BUS.register((Object)new DebugEffectEventHandler());
    }

    @SubscribeEvent
    public void onApplied(MobEffectAppliedEvent event) {
        this.log(event.getEntity(), "APPLIED", event.getEffectInstance());
    }

    @SubscribeEvent
    public void onRemoved(MobEffectRemovedEvent event) {
        this.log(event.getEntity(), "REMOVED", event.getEffectInstance());
    }

    @SubscribeEvent
    public void onExpired(MobEffectExpiredEvent event) {
        this.log(event.getEntity(), "EXPIRED", event.getEffectInstance());
    }

    private void log(LivingEntity entity, String action, MobEffectInstance effect) {
        System.out.println("[" + action + "] " + entity.getName().getString() + " - " + ((MobEffect)effect.getEffect().value()).toString());
    }
}

