/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.gui.furnaces;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import ironfurnaces.capability.ClientShowConfig;
import ironfurnaces.container.furnaces.BlockIronFurnaceContainerBase;
import ironfurnaces.items.ItemMillionFurnace;
import ironfurnaces.network.Messages;
import ironfurnaces.network.PacketFurnaceSettings;
import ironfurnaces.network.PacketShowConfig;
import ironfurnaces.util.StringHelper;
import ironfurnaces.util.gui.FurnaceGuiButton;
import ironfurnaces.util.gui.FurnaceGuiEnergy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class BlockIronFurnaceScreenBase<T extends BlockIronFurnaceContainerBase>
extends AbstractContainerScreen<T> {
    public ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace.png");
    public static final ResourceLocation GUI_NETHERITE = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_netherite.png");
    public static final ResourceLocation GUI_ATM = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_allthemodium.png");
    public static final ResourceLocation GUI_VIB = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_vibranium.png");
    public static final ResourceLocation GUI_UNOB = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_unobtainium.png");
    public static final ResourceLocation GUI_FACTORY = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_factory.png");
    public static final ResourceLocation GUI_GENERATOR = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_generator.png");
    public static final ResourceLocation GUI_GENERATOR_NETHERITE = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_generator_netherite.png");
    public static final ResourceLocation GUI_GENERATOR_ALLTHEMODIUM = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_generator_allthemodium.png");
    public static final ResourceLocation GUI_GENERATOR_VIBRANIUM = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_generator_vibranium.png");
    public static final ResourceLocation GUI_GENERATOR_UNOBTAINIUM = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/furnace_generator_unobtainium.png");
    public static final ResourceLocation GUI_AUGMENTS = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/augment.png");
    public static final ResourceLocation WIDGETS = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/widgets.png");
    Inventory playerInv;
    Component name;
    public List<FurnaceGuiButton> sideButtons = Lists.newArrayList();
    public FurnaceGuiButton autoSplitButton;
    public FurnaceGuiButton augmentButton;
    public FurnaceGuiButton autoInputButton;
    public FurnaceGuiButton autoOutputButton;
    public FurnaceGuiButton topButton;
    public FurnaceGuiButton leftButton;
    public FurnaceGuiButton frontButton;
    public FurnaceGuiButton rightButton;
    public FurnaceGuiButton bottomButton;
    public FurnaceGuiButton backButton;
    public FurnaceGuiButton redstoneIgnoredButton;
    public FurnaceGuiButton redstoneLowButton;
    public FurnaceGuiButton redstoneHighButton;
    public FurnaceGuiButton comparatorButton;
    public FurnaceGuiButton comparatorSubButton;
    public FurnaceGuiButton addButton;
    public FurnaceGuiButton subButton;
    public FurnaceGuiEnergy energyBar;
    private int timer;
    private Random rand = new Random();

    public BlockIronFurnaceScreenBase(T t, Inventory inv, Component name) {
        super(t, inv, name);
        this.playerInv = inv;
        this.name = name;
    }

    public void render(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        super.render(matrix, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrix, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.energyBar = new FurnaceGuiEnergy(left, top, 109, 22, 14, 42, 176, 14);
        this.autoSplitButton = new FurnaceGuiButton(left, top, 9, 56, 14, 14, 112, 189);
        this.augmentButton = new FurnaceGuiButton(left, top, 161, 4, 11, 11);
        this.autoInputButton = new FurnaceGuiButton(left, top, -47, 12, 14, 14, 0, 189);
        this.autoOutputButton = new FurnaceGuiButton(left, top, -29, 12, 14, 14, 14, 189);
        this.redstoneIgnoredButton = new FurnaceGuiButton(left, top, -47, 70, 14, 14, 28, 189);
        this.redstoneLowButton = new FurnaceGuiButton(left, top, -31, 70, 14, 14, 84, 189, 98, 189, 98, 189);
        this.redstoneHighButton = new FurnaceGuiButton(left, top, -31, 70, 14, 14, 42, 189);
        this.comparatorButton = new FurnaceGuiButton(left, top, -15, 70, 14, 14, 56, 189);
        this.comparatorSubButton = new FurnaceGuiButton(left, top, -47, 86, 14, 14, 70, 189);
        this.addButton = new FurnaceGuiButton(left, top, -31, 86, 14, 14, 0, 14, 14, 14, 28, 14);
        this.subButton = new FurnaceGuiButton(left, top, -31, 86, 14, 14, 0, 0, 14, 0, 28, 0);
        this.bottomButton = new FurnaceGuiButton(left, top, -32, 55, 10, 10);
        this.sideButtons.add(this.bottomButton);
        this.topButton = new FurnaceGuiButton(left, top, -32, 31, 10, 10);
        this.sideButtons.add(this.topButton);
        this.frontButton = new FurnaceGuiButton(left, top, -32, 43, 10, 10);
        this.sideButtons.add(this.frontButton);
        this.backButton = new FurnaceGuiButton(left, top, -20, 55, 10, 10);
        this.sideButtons.add(this.backButton);
        this.leftButton = new FurnaceGuiButton(left, top, -44, 43, 10, 10);
        this.sideButtons.add(this.leftButton);
        this.rightButton = new FurnaceGuiButton(left, top, -20, 43, 10, 10);
        this.sideButtons.add(this.rightButton);
    }

    private boolean showInventoryButtons() {
        return this.getShowConfig() == 1;
    }

    public void setShowConfig(int value) {
        ClientShowConfig.set(value);
        Messages.sendToServer(new PacketShowConfig(value));
    }

    public int getShowConfig() {
        return ClientShowConfig.getShowConfig();
    }

    protected void renderLabels(GuiGraphics matrix, int mouseX, int mouseY) {
        int actualMouseX = mouseX - (this.width - this.getXSize()) / 2;
        int actualMouseY = mouseY - (this.height - this.getYSize()) / 2;
        if (((BlockIronFurnaceContainerBase)this.getMenu()).isRainbowFurnace()) {
            ++this.timer;
            if (this.timer % 20 == 0) {
                this.timer = 0;
                String name = this.name.getString();
                ArrayList names = Lists.newArrayList();
                for (int i = 0; i < name.length(); ++i) {
                    names.add(Component.literal((String)("" + name.charAt(i))).withStyle(ChatFormatting.getById((int)ItemMillionFurnace.getIDRandom(this.rand.nextInt(6)))));
                }
                MutableComponent component = Component.literal((String)"");
                for (int i = 0; i < names.size(); ++i) {
                    component.append((Component)names.get(i));
                }
                this.name = component;
            }
        }
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory()) {
            matrix.drawString(this.font, this.name, this.getXSize() / 2 - this.minecraft.font.width(this.name.getString()) / 2, -10, 0xFFFFFF, false);
        } else {
            matrix.drawString(this.font, this.name, ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFurnace() ? 7 + this.getXSize() / 2 - this.minecraft.font.width(this.name.getString()) / 2 : this.getXSize() / 2 - this.minecraft.font.width(this.name.getString()) / 2, 6, 0x404040, false);
        }
        matrix.drawString(this.font, this.playerInv.getDisplayName(), 7, this.getYSize() - 93, 0x404040, false);
        if (this.showInventoryButtons() && ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode() == 4) {
            int comSub = ((BlockIronFurnaceContainerBase)this.getMenu()).getComSub();
            int i = comSub > 9 ? 28 : 31;
            matrix.drawString(this.font, (Component)Component.literal((String)("" + comSub)), i - 42, 90, 0x404040, false);
        }
        this.addTooltips(matrix, actualMouseX, actualMouseY);
    }

    private void addTooltips(GuiGraphics matrix, int mouseX, int mouseY) {
        this.augmentButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_open_augments"), mouseX, mouseY, !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        this.augmentButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_open_furnace"), mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        this.energyBar.changePos(109, 22, ((BlockIronFurnaceContainerBase)this.getMenu()).getIsGenerator() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        this.energyBar.changePos(9, 7, ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        this.energyBar.renderTooltip(this.font, matrix, mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getEnergy(), ((BlockIronFurnaceContainerBase)this.getMenu()).getMaxEnergy(), ((BlockIronFurnaceContainerBase)this.getMenu()).getIsGenerator() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        this.energyBar.renderTooltip(this.font, matrix, mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getEnergy(), ((BlockIronFurnaceContainerBase)this.getMenu()).getMaxEnergy(), ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        ArrayList tl = Lists.newArrayList((Object[])new Component[]{Component.literal((String)"Auto Split"), Component.literal((String)"ON")});
        this.autoSplitButton.renderComponentTooltip(this.font, matrix, tl, mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).isAutoSplit() && ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        tl = Lists.newArrayList((Object[])new Component[]{Component.literal((String)"Auto Split"), Component.literal((String)"OFF")});
        this.autoSplitButton.renderComponentTooltip(this.font, matrix, tl, mouseX, mouseY, !((BlockIronFurnaceContainerBase)this.getMenu()).isAutoSplit() && ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI());
        if (!this.showInventoryButtons()) {
            if (mouseX >= -20 && mouseX <= 0 && mouseY >= 4 && mouseY <= 26) {
                matrix.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_open"), mouseX, mouseY);
            }
        } else {
            if (mouseX >= -13 && mouseX <= 0 && mouseY >= 4 && mouseY <= 26) {
                matrix.renderComponentTooltip(this.font, StringHelper.getShiftInfoGui(), mouseX, mouseY);
            }
            ArrayList list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_auto_input"));
            list.add(Component.literal((String)(((BlockIronFurnaceContainerBase)this.getMenu()).getAutoInput() ? "ON" : "OFF")));
            this.autoInputButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_auto_output"));
            list.add(Component.literal((String)(((BlockIronFurnaceContainerBase)this.getMenu()).getAutoOutput() ? "ON" : "OFF")));
            this.autoOutputButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_top"));
            list.add(((BlockIronFurnaceContainerBase)this.getMenu()).getTooltip(Direction.UP.ordinal()));
            this.topButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_bottom"));
            list.add(((BlockIronFurnaceContainerBase)this.getMenu()).getTooltip(Direction.DOWN.ordinal()));
            this.bottomButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            if (BlockIronFurnaceScreenBase.isShiftKeyDown()) {
                list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_reset"));
            } else {
                list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_front"));
                list.add(((BlockIronFurnaceContainerBase)this.getMenu()).getTooltip(((BlockIronFurnaceContainerBase)this.getMenu()).getIndexFront()));
            }
            this.frontButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_back"));
            list.add(((BlockIronFurnaceContainerBase)this.getMenu()).getTooltip(((BlockIronFurnaceContainerBase)this.getMenu()).getIndexBack()));
            this.backButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_left"));
            list.add(((BlockIronFurnaceContainerBase)this.getMenu()).getTooltip(((BlockIronFurnaceContainerBase)this.getMenu()).getIndexLeft()));
            this.leftButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            list = Lists.newArrayList();
            list.add(Component.translatable((String)"tooltip.ironfurnaces.gui_right"));
            list.add(((BlockIronFurnaceContainerBase)this.getMenu()).getTooltip(((BlockIronFurnaceContainerBase)this.getMenu()).getIndexRight()));
            this.rightButton.renderComponentTooltip(this.font, matrix, list, mouseX, mouseY, true);
            this.redstoneIgnoredButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_redstone_ignored"), mouseX, mouseY, true);
            this.redstoneLowButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_redstone_low"), mouseX, mouseY, BlockIronFurnaceScreenBase.isShiftKeyDown());
            this.redstoneHighButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_redstone_high"), mouseX, mouseY, !BlockIronFurnaceScreenBase.isShiftKeyDown());
            this.comparatorButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_redstone_comparator"), mouseX, mouseY, true);
            this.comparatorSubButton.renderTooltip(this.font, matrix, (Component)Component.translatable((String)"tooltip.ironfurnaces.gui_redstone_comparator_sub"), mouseX, mouseY, true);
        }
    }

    private void bg(GuiGraphics matrix, int relX, int relY) {
        if (!((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory()) {
                matrix.blit(GUI_FACTORY, relX, relY, 0, 0, this.getXSize(), this.getYSize());
            }
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsGenerator()) {
                matrix.blit(GUI_GENERATOR, relX, relY, 0, 0, this.getXSize(), this.getYSize());
            }
            if (!((BlockIronFurnaceContainerBase)this.getMenu()).getIsGenerator() && !((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory()) {
                matrix.blit(this.GUI, relX, relY, 0, 0, this.getXSize(), this.getYSize());
            }
        } else {
            matrix.blit(GUI_AUGMENTS, relX, relY, 0, 0, this.getXSize(), this.getYSize());
        }
    }

    protected void renderFurnaceBg(GuiGraphics matrix) {
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFurnace() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            int i;
            if (((BlockIronFurnaceContainerBase)this.getMenu()).isBurning()) {
                i = ((BlockIronFurnaceContainerBase)this.getMenu()).getBurnLeftScaled(13);
                matrix.blit(this.GUI, this.getGuiLeft() + 56, this.getGuiTop() + 36 + 12 - i, 176, 12 - i, 14, i + 1);
            }
            i = ((BlockIronFurnaceContainerBase)this.getMenu()).getCookScaled(24);
            matrix.blit(this.GUI, this.getGuiLeft() + 79, this.getGuiTop() + 34, 176, 14, i + 1, 16);
        }
    }

    protected void renderGeneratorBg(GuiGraphics matrix) {
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsGenerator() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            if (((BlockIronFurnaceContainerBase)this.getMenu()).isGeneratorBurning()) {
                int i = ((BlockIronFurnaceContainerBase)this.getMenu()).getGeneratorBurnScaled(13);
                matrix.blit(GUI_GENERATOR, this.getGuiLeft() + 56, this.getGuiTop() + 23 + 12 - i, 176, 12 - i, 14, i + 1);
            }
            this.energyBar.render(GUI_GENERATOR, matrix, ((BlockIronFurnaceContainerBase)this.getMenu()).getEnergyScaled(42));
        }
    }

    protected void renderFactoryBg(GuiGraphics matrix) {
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            this.addSlots(matrix, ((BlockIronFurnaceContainerBase)this.getMenu()).getTier());
            this.energyBar.changePos(9, 7, true);
            this.energyBar.changeUV(176, 22, true);
            this.energyBar.render(GUI_FACTORY, matrix, ((BlockIronFurnaceContainerBase)this.getMenu()).getEnergyScaled(42));
            for (int j = 0; j < ((BlockIronFurnaceContainerBase)this.getMenu()).getFactoryCooktimeSize(); ++j) {
                int i = ((BlockIronFurnaceContainerBase)this.getMenu()).getFactoryCookScaled(j, 22);
                matrix.blit(GUI_FACTORY, this.getGuiLeft() + 29 + 21 * j, this.getGuiTop() + 27, 176, 0, 15, i + 1);
            }
        }
    }

    protected void renderBg(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        int relX = (this.width - this.getXSize()) / 2;
        int relY = (this.height - this.getYSize()) / 2;
        this.bg(matrix, relX, relY);
        this.renderFurnaceBg(matrix);
        this.renderGeneratorBg(matrix);
        this.renderFactoryBg(matrix);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS);
        int actualMouseX = mouseX - (this.width - this.getXSize()) / 2;
        int actualMouseY = mouseY - (this.height - this.getYSize()) / 2;
        this.addFactoryButtons(matrix, actualMouseX, actualMouseY);
        this.addInventoryButtons(matrix, actualMouseX, actualMouseY);
        this.addRedstoneButtons(matrix, actualMouseX, actualMouseY);
    }

    protected void addSlots(GuiGraphics matrix, int amount) {
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && amount > 0) {
            matrix.blit(GUI_FACTORY, this.getGuiLeft() + 48, this.getGuiTop() + 5, 176, 64, 18, 67);
            matrix.blit(GUI_FACTORY, this.getGuiLeft() + 111, this.getGuiTop() + 5, 176, 64, 18, 67);
            if (amount == 2) {
                matrix.blit(GUI_FACTORY, this.getGuiLeft() + 27, this.getGuiTop() + 5, 176, 64, 18, 67);
                matrix.blit(GUI_FACTORY, this.getGuiLeft() + 132, this.getGuiTop() + 5, 176, 64, 18, 67);
            }
        }
    }

    private void addFactoryButtons(GuiGraphics matrix, int mouseX, int mouseY) {
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory() && !((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            this.autoSplitButton.render(WIDGETS, matrix, mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).isAutoSplit());
        }
    }

    private void addRedstoneButtons(GuiGraphics matrix, int mouseX, int mouseY) {
        if (this.showInventoryButtons()) {
            boolean flag = BlockIronFurnaceScreenBase.isShiftKeyDown();
            int setting = ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode();
            if (setting == 0) {
                this.redstoneIgnoredButton.render(WIDGETS, matrix, mouseX, mouseY, true);
            }
            if (flag) {
                this.redstoneLowButton.render(WIDGETS, matrix, mouseX, mouseY, setting == 2);
            }
            if (!flag) {
                this.redstoneHighButton.render(WIDGETS, matrix, mouseX, mouseY, setting == 1);
            }
            if (setting == 3) {
                this.comparatorButton.render(WIDGETS, matrix, mouseX, mouseY, true);
            }
            if (setting == 4) {
                this.comparatorSubButton.render(WIDGETS, matrix, mouseX, mouseY, true);
                int comSub = ((BlockIronFurnaceContainerBase)this.getMenu()).getComSub();
                this.addButton.render(WIDGETS, matrix, mouseX, mouseY, comSub == 15);
                if (flag) {
                    this.subButton.render(WIDGETS, matrix, mouseX, mouseY, comSub == 0);
                }
            }
        }
    }

    private void addInventoryButtons(GuiGraphics matrix, int mouseX, int mouseY) {
        if (!this.showInventoryButtons()) {
            matrix.blit(WIDGETS, this.getGuiLeft() - 20, this.getGuiTop() + 4, 0, 28, 23, 26);
        } else if (this.showInventoryButtons()) {
            matrix.blit(WIDGETS, this.getGuiLeft() - 56, this.getGuiTop() + 4, 0, 54, 59, 107);
            this.autoInputButton.render(WIDGETS, matrix, mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getAutoInput());
            this.autoOutputButton.render(WIDGETS, matrix, mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getAutoOutput());
            this.blitIO(matrix, mouseX, mouseY);
        }
    }

    private void blitIO(GuiGraphics matrix, int mouseX, int mouseY) {
        int[] settings = new int[]{((BlockIronFurnaceContainerBase)this.getMenu()).getSettingBottom(), ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingTop(), ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingFront(), ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingBack(), ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingLeft(), ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingRight()};
        for (int i = 0; i < settings.length && settings.length == this.sideButtons.size(); ++i) {
            if (settings[i] == 0) continue;
            FurnaceGuiButton button = this.sideButtons.get(i);
            button.changeEnabledUV(10 * settings[i] - 10, 161);
            button.render(WIDGETS, matrix, mouseX, mouseY, true);
        }
        if (((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            return;
        }
        boolean input = false;
        boolean output = false;
        boolean both = false;
        boolean fuel = false;
        for (int set : settings) {
            if (set == 1) {
                input = true;
                continue;
            }
            if (set == 2) {
                output = true;
                continue;
            }
            if (set == 3) {
                both = true;
                continue;
            }
            if (set != 4) continue;
            fuel = true;
        }
        if (input || both) {
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFurnace()) {
                matrix.blit(WIDGETS, this.getGuiLeft() + 55, this.getGuiTop() + 16, 0, 171, 18, 18);
            }
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory()) {
                matrix.blit(WIDGETS, this.getGuiLeft() + 69, this.getGuiTop() + 5, 0, 171, 18, 18);
                matrix.blit(WIDGETS, this.getGuiLeft() + 90, this.getGuiTop() + 5, 0, 171, 18, 18);
                if (((BlockIronFurnaceContainerBase)this.getMenu()).getTier() > 0) {
                    matrix.blit(WIDGETS, this.getGuiLeft() + 48, this.getGuiTop() + 5, 0, 171, 18, 18);
                    matrix.blit(WIDGETS, this.getGuiLeft() + 111, this.getGuiTop() + 5, 0, 171, 18, 18);
                    if (((BlockIronFurnaceContainerBase)this.getMenu()).getTier() > 1) {
                        matrix.blit(WIDGETS, this.getGuiLeft() + 27, this.getGuiTop() + 5, 0, 171, 18, 18);
                        matrix.blit(WIDGETS, this.getGuiLeft() + 132, this.getGuiTop() + 5, 0, 171, 18, 18);
                    }
                }
            }
        }
        if (output || both) {
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFurnace()) {
                matrix.blit(WIDGETS, this.getGuiLeft() + 111, this.getGuiTop() + 30, 0, 203, 26, 26);
            }
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory()) {
                matrix.blit(WIDGETS, this.getGuiLeft() + 69, this.getGuiTop() + 54, 36, 171, 18, 18);
                matrix.blit(WIDGETS, this.getGuiLeft() + 90, this.getGuiTop() + 54, 36, 171, 18, 18);
                if (((BlockIronFurnaceContainerBase)this.getMenu()).getTier() > 0) {
                    matrix.blit(WIDGETS, this.getGuiLeft() + 48, this.getGuiTop() + 54, 36, 171, 18, 18);
                    matrix.blit(WIDGETS, this.getGuiLeft() + 111, this.getGuiTop() + 54, 36, 171, 18, 18);
                    if (((BlockIronFurnaceContainerBase)this.getMenu()).getTier() > 1) {
                        matrix.blit(WIDGETS, this.getGuiLeft() + 27, this.getGuiTop() + 54, 36, 171, 18, 18);
                        matrix.blit(WIDGETS, this.getGuiLeft() + 132, this.getGuiTop() + 54, 36, 171, 18, 18);
                    }
                }
            }
        }
        if (fuel) {
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsFurnace()) {
                matrix.blit(WIDGETS, this.getGuiLeft() + 55, this.getGuiTop() + 52, 18, 171, 18, 18);
            }
            if (((BlockIronFurnaceContainerBase)this.getMenu()).getIsGenerator()) {
                matrix.blit(WIDGETS, this.getGuiLeft() + 55, this.getGuiTop() + 39, 18, 171, 18, 18);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double actualMouseX = mouseX - ((double)this.width - (double)this.getXSize()) / 2.0;
        double actualMouseY = mouseY - ((double)this.height - (double)this.getYSize()) / 2.0;
        this.mouseClickedRedstoneButtons(actualMouseX, actualMouseY);
        this.mouseClickedInventoryButtons(button, actualMouseX, actualMouseY);
        this.mouseClickedAugmentButton(actualMouseX, actualMouseY);
        this.mouseClickedAutoSplitButton(actualMouseX, actualMouseY);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseClickedAutoSplitButton(double mouseX, double mouseY) {
        if (!((BlockIronFurnaceContainerBase)this.getMenu()).isAutoSplit()) {
            this.autoSplitButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 11, 1, ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory());
        } else {
            this.autoSplitButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 11, 0, ((BlockIronFurnaceContainerBase)this.getMenu()).getIsFactory());
        }
    }

    public void mouseClickedAugmentButton(double mouseX, double mouseY) {
        if (!((BlockIronFurnaceContainerBase)this.getMenu()).getAugmentGUI()) {
            this.augmentButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 10, 1, true);
        } else {
            this.augmentButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 10, 0, true);
        }
    }

    public void mouseClickedInventoryButtons(int button, double mouseX, double mouseY) {
        if (!this.showInventoryButtons()) {
            if (mouseX >= -20.0 && mouseX <= 0.0 && mouseY >= 4.0 && mouseY <= 26.0) {
                this.setShowConfig(1);
            }
        } else {
            if (mouseX >= -13.0 && mouseX <= 0.0 && mouseY >= 4.0 && mouseY <= 26.0) {
                this.setShowConfig(0);
            }
            if (!((BlockIronFurnaceContainerBase)this.getMenu()).getAutoInput()) {
                this.autoInputButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 6, 1, true);
            } else if (((BlockIronFurnaceContainerBase)this.getMenu()).getAutoInput()) {
                this.autoInputButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 6, 0, true);
            }
            if (!((BlockIronFurnaceContainerBase)this.getMenu()).getAutoOutput()) {
                this.autoOutputButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 7, 1, true);
            } else if (((BlockIronFurnaceContainerBase)this.getMenu()).getAutoOutput()) {
                this.autoOutputButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 7, 0, true);
            }
            this.clickInvButton(mouseX, mouseY, this.topButton, button, ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingTop(), Direction.UP.ordinal());
            this.clickInvButton(mouseX, mouseY, this.bottomButton, button, ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingBottom(), Direction.DOWN.ordinal());
            this.clickInvButton(mouseX, mouseY, this.frontButton, button, ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingFront(), ((BlockIronFurnaceContainerBase)this.getMenu()).getIndexFront(), BlockIronFurnaceScreenBase.isShiftKeyDown());
            this.clickInvButton(mouseX, mouseY, this.backButton, button, ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingBack(), ((BlockIronFurnaceContainerBase)this.getMenu()).getIndexBack());
            this.clickInvButton(mouseX, mouseY, this.leftButton, button, ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingLeft(), ((BlockIronFurnaceContainerBase)this.getMenu()).getIndexLeft());
            this.clickInvButton(mouseX, mouseY, this.rightButton, button, ((BlockIronFurnaceContainerBase)this.getMenu()).getSettingRight(), ((BlockIronFurnaceContainerBase)this.getMenu()).getIndexRight());
        }
    }

    protected void clickInvButton(double mouseX, double mouseY, FurnaceGuiButton button, int buttonid, int setting, int index) {
        this.clickInvButton(mouseX, mouseY, button, buttonid, setting, index, false);
    }

    protected void clickInvButton(double mouseX, double mouseY, FurnaceGuiButton button, int buttonid, int setting, int index, boolean shift) {
        int set = setting == 4 ? 0 : setting + 1;
        button.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), index, set, buttonid == 0);
        set = setting == 0 ? 4 : setting - 1;
        button.onRightClick(mouseX, mouseY, buttonid, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), index, set, true);
        if (shift && this.frontButton.hovering(mouseX, mouseY)) {
            for (int i = 0; i < this.sideButtons.size(); ++i) {
                Messages.sendToServer(new PacketFurnaceSettings(((BlockIronFurnaceContainerBase)this.getMenu()).getPos().getX(), ((BlockIronFurnaceContainerBase)this.getMenu()).getPos().getY(), ((BlockIronFurnaceContainerBase)this.getMenu()).getPos().getZ(), i, 0));
            }
        }
    }

    public void mouseClickedRedstoneButtons(double mouseX, double mouseY) {
        if (this.showInventoryButtons()) {
            boolean shift = BlockIronFurnaceScreenBase.isShiftKeyDown();
            this.addButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 9, ((BlockIronFurnaceContainerBase)this.getMenu()).getComSub() + 1, !shift && ((BlockIronFurnaceContainerBase)this.getMenu()).getComSub() < 15);
            this.subButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 9, ((BlockIronFurnaceContainerBase)this.getMenu()).getComSub() - 1, shift && ((BlockIronFurnaceContainerBase)this.getMenu()).getComSub() > 0);
            this.redstoneIgnoredButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 8, 0, ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode() != 0);
            this.redstoneLowButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 8, 2, ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode() != 2 && shift);
            this.redstoneHighButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 8, 1, ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode() != 1 && !shift);
            this.comparatorButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 8, 3, ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode() != 3);
            this.comparatorSubButton.onClick(mouseX, mouseY, ((BlockIronFurnaceContainerBase)this.getMenu()).getPos(), 8, 4, ((BlockIronFurnaceContainerBase)this.getMenu()).getRedstoneMode() != 4);
        }
    }

    public static boolean isShiftKeyDown() {
        return BlockIronFurnaceScreenBase.isKeyDown(340) || BlockIronFurnaceScreenBase.isKeyDown(344);
    }

    public static boolean isKeyDown(int glfw) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.getOrCreate(glfw);
        int keyCode = key.getValue();
        if (keyCode != InputConstants.UNKNOWN.getValue()) {
            long windowHandle = Minecraft.getInstance().getWindow().getWindow();
            try {
                if (key.getType() == InputConstants.Type.KEYSYM) {
                    return InputConstants.isKeyDown((long)windowHandle, (int)keyCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

