/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.attribute;

import java.util.Set;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import net.minecraft.core.Holder;

public interface ChemicalAttributeValidator {
    public static final ChemicalAttributeValidator DEFAULT = new ChemicalAttributeValidatorLegacyAdapter(){

        @Override
        public boolean validate(IChemicalAttribute attr) {
            return !attr.needsValidation();
        }

        @Override
        public boolean process(Chemical chemical) {
            return !chemical.hasAttributesWithValidation();
        }
    };
    public static final ChemicalAttributeValidator ALWAYS_ALLOW = new ChemicalAttributeValidatorLegacyAdapter(){

        @Override
        public boolean validate(IChemicalAttribute attr) {
            return true;
        }

        @Override
        public boolean process(Chemical chemical) {
            return true;
        }
    };

    @Deprecated(forRemoval=true, since="10.7.11")
    public boolean validate(ChemicalAttribute var1);

    default public boolean validate(IChemicalAttribute attribute) {
        return this.validate(attribute.toLegacyAttribute());
    }

    default public boolean process(Holder<Chemical> chemical) {
        return this.process((Chemical)chemical.value());
    }

    default public boolean process(Chemical chemical) {
        for (ChemicalAttribute chemicalAttribute : chemical.getAttributes()) {
            if (this.validate(chemicalAttribute)) continue;
            return false;
        }
        return true;
    }

    default public boolean process(ChemicalStack stack) {
        return this.process(stack.getChemicalHolder());
    }

    @SafeVarargs
    public static ChemicalAttributeValidator create(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, true);
    }

    @SafeVarargs
    public static ChemicalAttributeValidator createStrict(Class<? extends ChemicalAttribute> ... validAttributes) {
        return new SimpleAttributeValidator(validAttributes, false);
    }

    public static class SimpleAttributeValidator
    implements ChemicalAttributeValidator {
        private final Set<Class<? extends ChemicalAttribute>> validTypes;
        private final boolean allowNoValidation;

        SimpleAttributeValidator(Class<? extends ChemicalAttribute>[] attributeTypes, boolean allowNoValidation) {
            this.validTypes = Set.of(attributeTypes);
            this.allowNoValidation = allowNoValidation;
        }

        @Override
        public boolean validate(ChemicalAttribute attribute) {
            return this.allowNoValidation && !attribute.needsValidation() || this.validTypes.contains(attribute.getClass());
        }
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public static interface ChemicalAttributeValidatorLegacyAdapter
    extends ChemicalAttributeValidator {
        @Override
        @Deprecated(forRemoval=true, since="10.7.11")
        default public boolean validate(ChemicalAttribute attribute) {
            return this.validate((IChemicalAttribute)attribute);
        }

        @Override
        public boolean validate(IChemicalAttribute var1);

        @Override
        default public boolean process(Chemical chemical) {
            for (IChemicalAttribute attribute : chemical.getModernAttributes()) {
                if (this.validate(attribute)) continue;
                return false;
            }
            for (ChemicalAttribute chemicalAttribute : chemical.getLegacyAttributes()) {
                IChemicalAttribute modernVersion = chemicalAttribute.asModern();
                if (!(modernVersion != null ? !this.validate(modernVersion) : !this.validate(chemicalAttribute))) continue;
                return false;
            }
            return true;
        }
    }
}

