/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public abstract class ModuleConfig<DATA> {
    public static final ResourceLocation ENABLED_KEY = ModuleConfig.rl("enabled");
    public static final ResourceLocation HANDLES_MODE_CHANGE_KEY = ModuleConfig.rl("handle_mode_change");
    public static final ResourceLocation RENDER_HUD_KEY = ModuleConfig.rl("render_hud");
    private final ResourceLocation name;

    private static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)path);
    }

    protected static <DATA, CONFIG extends ModuleConfig<DATA>> Products.P1<RecordCodecBuilder.Mu<CONFIG>, ResourceLocation> baseCodec(RecordCodecBuilder.Instance<CONFIG> instance) {
        return instance.group((App)ResourceLocation.CODEC.xmap(rl -> rl.getNamespace().equals("minecraft") ? ModuleConfig.rl(rl.getPath()) : rl, Function.identity()).fieldOf("name").forGetter(ModuleConfig::name));
    }

    protected ModuleConfig(ResourceLocation name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null.");
    }

    public final ResourceLocation name() {
        return this.name;
    }

    public abstract StreamCodec<? super RegistryFriendlyByteBuf, ModuleConfig<DATA>> namedStreamCodec(ResourceLocation var1);

    public abstract DATA get();

    public abstract ModuleConfig<DATA> with(DATA var1);

    public boolean isConfigDisabled() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.name.equals((Object)((ModuleConfig)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

