/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.vanilla_input;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.vanilla_input.FluidRecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public record SingleFluidRecipeInput(FluidStack fluid) implements FluidRecipeInput
{
    @Override
    public FluidStack getFluid(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No fluid for index " + index);
        }
        return this.fluid;
    }

    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return FluidStack.matches((FluidStack)this.fluid, (FluidStack)((SingleFluidRecipeInput)o).fluid);
    }

    @Override
    public int hashCode() {
        int hash = FluidStack.hashFluidAndComponents((FluidStack)this.fluid);
        return 31 * hash + this.fluid.getAmount();
    }
}

