/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.filter.transporter.GuiSorterFilerSelect;
import mekanism.client.gui.element.window.filter.transporter.GuiSorterItemStackFilter;
import mekanism.client.gui.element.window.filter.transporter.GuiSorterModIDFilter;
import mekanism.client.gui.element.window.filter.transporter.GuiSorterTagFilter;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.content.transporter.SorterModIDFilter;
import mekanism.common.content.transporter.SorterTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiLogisticalSorter
extends GuiFilterHolder<SorterFilter<?>, TileEntityLogisticalSorter, MekanismTileContainer<TileEntityLogisticalSorter>> {
    public GuiLogisticalSorter(MekanismTileContainer<TileEntityLogisticalSorter> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 12, 136).setRenderAboveSlots());
        this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 96, 136, 156, 20, MekanismLang.BUTTON_NEW_FILTER, (element, mouseX, mouseY) -> {
            GuiLogisticalSorter gui = (GuiLogisticalSorter)element.gui();
            gui.addWindow(new GuiSorterFilerSelect(gui, (TileEntityLogisticalSorter)gui.tile));
            return true;
        }));
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 12, 46, 14, this.getButtonLocation("single"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SINGLE_ITEM_BUTTON, ((GuiLogisticalSorter)element.gui()).tile)))).setTooltip(MekanismLang.SORTER_SINGLE_ITEM_DESCRIPTION);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 12, 76, 14, this.getButtonLocation("round_robin"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.ROUND_ROBIN_BUTTON, ((GuiLogisticalSorter)element.gui()).tile)))).setTooltip(MekanismLang.SORTER_ROUND_ROBIN_DESCRIPTION);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 12, 106, 14, this.getButtonLocation("auto_eject"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_EJECT_BUTTON, ((GuiLogisticalSorter)element.gui()).tile)))).setTooltip(MekanismLang.SORTER_AUTO_EJECT_DESCRIPTION);
        this.addRenderableWidget(new ColorButton((IGuiWrapper)this, 13, 137, 16, 16, () -> ((TileEntityLogisticalSorter)this.tile).color, (element, mouseX, mouseY) -> {
            TileEntityLogisticalSorter tile = (TileEntityLogisticalSorter)((GuiLogisticalSorter)element.gui()).tile;
            return PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CHANGE_COLOR, (BlockEntity)tile, GuiLogisticalSorter.hasShiftDown() ? -1 : TransporterUtils.getColorIndex(TransporterUtils.increment(tile.color))));
        }, (element, mouseX, mouseY) -> {
            TileEntityLogisticalSorter tile = (TileEntityLogisticalSorter)((GuiLogisticalSorter)element.gui()).tile;
            return PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CHANGE_COLOR, (BlockEntity)tile, TransporterUtils.getColorIndex(TransporterUtils.decrement(tile.color))));
        }));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
        this.renderTitleText(guiGraphics);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.FILTER_COUNT.translate(this.getFilterManager().count()), 4);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.SORTER_SINGLE_ITEM.translate(), 19);
        this.drawScreenText(guiGraphics, BooleanStateDisplay.OnOff.of(((TileEntityLogisticalSorter)this.tile).getSingleItem()).getTextComponent(), 14, 32);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.SORTER_ROUND_ROBIN.translate(), 49);
        this.drawScreenText(guiGraphics, BooleanStateDisplay.OnOff.of(((TileEntityLogisticalSorter)this.tile).getRoundRobin()).getTextComponent(), 14, 62);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.SORTER_AUTO_EJECT.translate(), 79);
        this.drawScreenText(guiGraphics, BooleanStateDisplay.OnOff.of(((TileEntityLogisticalSorter)this.tile).getAutoEject()).getTextComponent(), 14, 92);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.SORTER_DEFAULT.translate(), 109);
    }

    @Override
    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiSorterItemStackFilter.edit(this, (TileEntityLogisticalSorter)this.tile, (SorterItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiSorterTagFilter.edit(this, (TileEntityLogisticalSorter)this.tile, (SorterTagFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiSorterModIDFilter.edit(this, (TileEntityLogisticalSorter)this.tile, (SorterModIDFilter)filter));
        }
    }

    @Override
    protected List<ItemStack> getTagStacks(String tagName) {
        return TagCache.getItemTagStacks(tagName);
    }

    @Override
    protected List<ItemStack> getModIDStacks(String tagName) {
        return TagCache.getItemModIDStacks(tagName);
    }
}

