/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiSecurityLight;
import mekanism.client.gui.element.GuiTextureOnlyElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TooltipToggleButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketAddTrusted;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiSecurityDesk
extends GuiMekanismTile<TileEntitySecurityDesk, MekanismTileContainer<TileEntitySecurityDesk>> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private MekanismButton removeButton;
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton trustedButton;
    private MekanismButton overrideButton;
    private GuiTextScrollList scrollList;
    private GuiTextField trustedField;

    public GuiSecurityDesk(MekanismTileContainer<TileEntitySecurityDesk> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageHeight += 64;
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelY = 4;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        this.addRenderableWidget(new GuiElementHolder(this, 141, 13, 26, 37));
        this.addRenderableWidget(new GuiElementHolder(this, 141, 54, 26, 34));
        this.addRenderableWidget(new GuiElementHolder(this, 141, 92, 26, 37));
        super.addGuiElements();
        this.addRenderableWidget(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 17));
        this.addRenderableWidget(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 96));
        this.addRenderableWidget(new GuiSecurityLight(this, 144, 77, () -> {
            SecurityFrequency frequency = ((TileEntitySecurityDesk)this.tile).getFreq();
            if (!this.isOwner(frequency)) {
                return 2;
            }
            return frequency.isOverridden() ? 0 : 1;
        }));
        this.addRenderableWidget(new GuiTextureOnlyElement(PUBLIC, this, 145, 32, 18, 18));
        this.addRenderableWidget(new GuiTextureOnlyElement(PRIVATE, this, 145, 111, 18, 18));
        this.scrollList = this.addRenderableWidget(new GuiTextScrollList(this, 13, 13, 122, 42));
        this.removeButton = this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 13, 81, 122, 20, MekanismLang.BUTTON_REMOVE, (element, mouseX, mouseY) -> {
            GuiSecurityDesk desk = (GuiSecurityDesk)element.gui();
            int selection = desk.scrollList.getSelection();
            if (((TileEntitySecurityDesk)desk.tile).getFreq() != null && selection != -1) {
                PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.REMOVE_TRUSTED, (BlockEntity)desk.tile, selection));
                desk.scrollList.clearSelection();
                desk.updateButtons();
                return true;
            }
            return false;
        }));
        this.trustedField = this.addRenderableWidget(new GuiTextField(this, 35, 68, 99, 11));
        this.trustedField.setMaxLength(16);
        this.trustedField.setBackground(BackgroundType.INNER_SCREEN);
        this.trustedField.setEnterHandler(this::setTrusted);
        this.trustedField.setInputValidator(InputValidator.USERNAME);
        this.trustedField.addCheckmarkButton(this::setTrusted);
        this.publicButton = this.addRenderableWidget(new MekanismImageButton(this, 13, 113, 40, 16, 40, 16, this.getButtonLocation("public"), (element, mouseX, mouseY) -> {
            GuiSecurityDesk desk = (GuiSecurityDesk)element.gui();
            PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, (BlockEntity)desk.tile, SecurityMode.PUBLIC.ordinal()));
            desk.updateButtons();
            return true;
        })).setTooltip(MekanismLang.PUBLIC_MODE);
        this.privateButton = this.addRenderableWidget(new MekanismImageButton(this, 54, 113, 40, 16, 40, 16, this.getButtonLocation("private"), (element, mouseX, mouseY) -> {
            GuiSecurityDesk desk = (GuiSecurityDesk)element.gui();
            PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, (BlockEntity)desk.tile, SecurityMode.PRIVATE.ordinal()));
            desk.updateButtons();
            return true;
        })).setTooltip(MekanismLang.PRIVATE_MODE);
        this.trustedButton = this.addRenderableWidget(new MekanismImageButton(this, 95, 113, 40, 16, 40, 16, this.getButtonLocation("trusted"), (element, mouseX, mouseY) -> {
            GuiSecurityDesk desk = (GuiSecurityDesk)element.gui();
            PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, (BlockEntity)desk.tile, SecurityMode.TRUSTED.ordinal()));
            desk.updateButtons();
            return true;
        })).setTooltip(MekanismLang.TRUSTED_MODE);
        this.overrideButton = this.addRenderableWidget(new TooltipToggleButton((IGuiWrapper)this, 146, 59, 16, 16, this.getButtonLocation("exclamation"), () -> {
            SecurityFrequency frequency = ((TileEntitySecurityDesk)this.tile).getFreq();
            return frequency != null && frequency.isOverridden();
        }, (element, mouseX, mouseY) -> {
            GuiSecurityDesk desk = (GuiSecurityDesk)element.gui();
            PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.OVERRIDE_BUTTON, desk.tile));
            desk.updateButtons();
            return true;
        }, (Component)MekanismLang.SECURITY_OVERRIDE.translate(BooleanStateDisplay.OnOff.ON), (Component)MekanismLang.SECURITY_OVERRIDE.translate(BooleanStateDisplay.OnOff.OFF)));
        this.updateButtons();
    }

    private boolean isOwner(@Nullable SecurityFrequency frequency) {
        return frequency != null && ((TileEntitySecurityDesk)this.tile).ownerMatches((Player)this.getMinecraft().player);
    }

    private void setTrusted() {
        if (this.isOwner(((TileEntitySecurityDesk)this.tile).getFreq())) {
            this.addTrusted(this.trustedField.getText().trim());
            this.trustedField.setText("");
            this.updateButtons();
        }
    }

    private void addTrusted(String trusted) {
        if (StringUtil.isValidPlayerName((String)trusted)) {
            PacketUtils.sendToServer(new PacketAddTrusted(((TileEntitySecurityDesk)this.tile).getBlockPos(), trusted));
        }
    }

    private void updateButtons() {
        SecurityFrequency freq = ((TileEntitySecurityDesk)this.tile).getFreq();
        if (((TileEntitySecurityDesk)this.tile).getOwnerUUID() != null) {
            this.scrollList.setText(freq == null ? Collections.emptyList() : freq.getTrustedUsernameCache());
            this.removeButton.active = this.scrollList.hasSelection();
        }
        if (this.isOwner(freq)) {
            this.publicButton.active = freq.getSecurity() != SecurityMode.PUBLIC;
            this.privateButton.active = freq.getSecurity() != SecurityMode.PRIVATE;
            this.trustedButton.active = freq.getSecurity() != SecurityMode.TRUSTED;
            this.overrideButton.active = true;
        } else {
            this.publicButton.active = false;
            this.privateButton.active = false;
            this.trustedButton.active = false;
            this.overrideButton.active = false;
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.updateButtons();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        Component ownerComponent = OwnerDisplay.of(((TileEntitySecurityDesk)this.tile).getOwnerUUID(), ((TileEntitySecurityDesk)this.tile).getOwnerName()).getTextComponent();
        this.renderInventoryTextAndOther(guiGraphics, ownerComponent);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.TRUSTED_PLAYERS.translate(), 13, 57, IFancyFontRenderer.TextAlignment.CENTER, this.subheadingTextColor(), 122, 0, false);
        SecurityFrequency frequency = ((TileEntitySecurityDesk)this.tile).getFreq();
        MutableComponent frequencyText = frequency == null ? MekanismLang.SECURITY_OFFLINE.translateColored(EnumColor.RED) : MekanismLang.SECURITY.translate(frequency.getSecurity());
        this.drawScrollingString(guiGraphics, (Component)frequencyText, 13, 103, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 122, 0, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.SECURITY_ADD.translate(), 1, 70, IFancyFontRenderer.TextAlignment.RIGHT, this.titleTextColor(), this.trustedField.getRelativeX() - 1, 3, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

