/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ChemicalEmiIngredientSerializer
implements EmiStackSerializer<ChemicalEmiStack> {
    public EmiStack create(ResourceLocation id, DataComponentPatch ignored, long amount) {
        Optional<Holder.Reference> chemical = MekanismAPI.CHEMICAL_REGISTRY.getHolder(id).filter(c -> !c.is(MekanismAPI.EMPTY_CHEMICAL_KEY));
        if (chemical.isPresent()) {
            return new ChemicalEmiStack((Holder<Chemical>)((Holder)chemical.get()), amount);
        }
        return EmiStack.EMPTY;
    }

    public String getType() {
        return "mekanism_chemical";
    }

    void addEmiStacks(EmiRegistry emiRegistry) {
        MekanismAPI.CHEMICAL_REGISTRY.holders().forEach(chemical -> {
            if (!chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                emiRegistry.addEmiStack((EmiStack)new ChemicalEmiStack((Holder<Chemical>)chemical, 1L));
            }
        });
    }
}

