/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import java.util.Collections;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.gui.element.GuiElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

@NothingNullByDefault
public class MekanismEmiWidget
extends Widget {
    private final boolean forwardClicks;
    private final GuiElement element;
    private final Bounds bounds;

    public MekanismEmiWidget(GuiElement element, boolean forwardClicks) {
        this.element = element;
        this.forwardClicks = forwardClicks;
        this.bounds = new Bounds(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)this.element.getGuiLeft(), (float)this.element.getGuiTop(), 0.0f);
        this.element.renderShifted(guiGraphics, mouseX, mouseY, 0.0f);
        this.element.onDrawBackground(guiGraphics, mouseX, mouseY, 0.0f);
        int zOffset = 200;
        pose.pushPose();
        this.element.onRenderForeground(guiGraphics, mouseX, mouseY, zOffset, zOffset);
        pose.popPose();
        pose.popPose();
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        this.element.updateTooltip(mouseX, mouseY);
        Tooltip tooltip = this.element.getTooltip();
        if (tooltip != null) {
            return tooltip.toCharSequence(Minecraft.getInstance()).stream().map(ClientTooltipComponent::create).toList();
        }
        return Collections.emptyList();
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.forwardClicks && this.element.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.element.keyPressed(keyCode, scanCode, modifiers);
    }
}

