/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.common.util.EnumUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;

public class Outlines {
    public static List<Line> extract(BakedModel model, @Nullable BlockState state, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        HashSet<Line> lines = new HashSet<Line>();
        VertexExtractor consumer = new VertexExtractor(lines);
        for (Direction direction : EnumUtils.DIRECTIONS) {
            for (BakedQuad quad : model.getQuads(state, direction, rand, modelData, renderType)) {
                consumer.unpack(quad);
            }
        }
        for (BakedQuad quad : model.getQuads(state, null, rand, modelData, renderType)) {
            consumer.unpack(quad);
        }
        return new ArrayList<Line>(lines);
    }

    @MethodsReturnNonnullByDefault
    private static class VertexExtractor {
        final Set<Line> lines;
        final Vector3f[] vertices = new Vector3f[4];
        int vertexIndex = 0;

        private VertexExtractor(Set<Line> lines) {
            this.lines = lines;
        }

        public void vertex(float pX, float pY, float pZ) {
            this.vertices[this.vertexIndex++] = new Vector3f(pX, pY, pZ);
            if (this.vertexIndex == 4) {
                this.vertexIndex = 0;
                this.lines.add(Line.from(this.vertices[0], this.vertices[1]));
                this.lines.add(Line.from(this.vertices[1], this.vertices[2]));
                this.lines.add(Line.from(this.vertices[2], this.vertices[3]));
                this.lines.add(Line.from(this.vertices[3], this.vertices[0]));
                Arrays.fill(this.vertices, null);
            }
        }

        public void unpack(BakedQuad pQuad) {
            int[] quadVertices = pQuad.getVertices();
            for (int i = 0; i < 4; ++i) {
                int offset = i * IQuadTransformer.STRIDE + IQuadTransformer.POSITION;
                float x = Float.intBitsToFloat(quadVertices[offset]);
                float y = Float.intBitsToFloat(quadVertices[offset + 1]);
                float z = Float.intBitsToFloat(quadVertices[offset + 2]);
                this.vertex(x, y, z);
            }
        }
    }

    public record Line(float x1, float y1, float z1, float x2, float y2, float z2, float nX, float nY, float nZ, int hash) {
        public static Line from(Vector3f v1, Vector3f v2) {
            float nX = v2.x - v1.x;
            float nY = v2.y - v1.y;
            float nZ = v2.z - v1.z;
            float scalar = Math.invsqrt((float)Math.fma((float)nX, (float)nX, (float)Math.fma((float)nY, (float)nY, (float)(nZ * nZ))));
            return new Line(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, nX *= scalar, nY *= scalar, nZ *= scalar, Line.calculateHash(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z));
        }

        private static int calculateHash(float x1, float y1, float z1, float x2, float y2, float z2) {
            int result = Long.hashCode((long)Math.min((float)x1, (float)x2) * 3200L);
            result = 31 * result + Long.hashCode((long)Math.min((float)y1, (float)y2) * 3200L);
            result = 31 * result + Long.hashCode((long)Math.min((float)z1, (float)z2) * 3200L);
            result = 31 * result + Long.hashCode((long)Math.max((float)x1, (float)x2) * 3200L);
            result = 31 * result + Long.hashCode((long)Math.max((float)x1, (float)x2) * 3200L);
            result = 31 * result + Long.hashCode((long)Math.max((float)x1, (float)x2) * 3200L);
            return result;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Line.class) {
                return false;
            }
            Line other = (Line)obj;
            return Mth.equal((float)this.x1, (float)other.x1) && Mth.equal((float)this.y1, (float)other.y1) && Mth.equal((float)this.z1, (float)other.z1) && Mth.equal((float)this.x2, (float)other.x2) && Mth.equal((float)this.y2, (float)other.y2) && Mth.equal((float)this.z2, (float)other.z2) || Mth.equal((float)this.x1, (float)other.x2) && Mth.equal((float)this.y1, (float)other.y2) && Mth.equal((float)this.z1, (float)other.z2) && Mth.equal((float)this.x2, (float)other.x1) && Mth.equal((float)this.y2, (float)other.y1) && Mth.equal((float)this.z2, (float)other.z1);
        }
    }
}

