/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public record StabilizedChunks(byte[] chunks) {
    private static final int ARRAY_SIZE = 25;
    public static final StabilizedChunks NONE = new StabilizedChunks(new byte[25]);
    public static final Codec<StabilizedChunks> CODEC = Codec.BYTE.listOf(25, 25).xmap(bytes -> {
        byte[] chunks = new byte[25];
        for (int i = 0; i < 25; ++i) {
            chunks[i] = (Byte)bytes.get(i);
        }
        return new StabilizedChunks(chunks);
    }, chunks -> {
        ArrayList<Byte> list = new ArrayList<Byte>(25);
        for (byte chunk : chunks.chunks()) {
            list.add(chunk);
        }
        return list;
    });
    public static final StreamCodec<ByteBuf, StabilizedChunks> STREAM_CODEC = ByteBufCodecs.byteArray((int)25).map(StabilizedChunks::new, StabilizedChunks::chunks);

    public StabilizedChunks {
        if (chunks.length != 25) {
            throw new IllegalArgumentException("Expected to have 25 chunks, but got " + chunks.length);
        }
    }

    public static StabilizedChunks create(TileEntityDimensionalStabilizer stabilizer) {
        byte[] chunksToLoad = new byte[25];
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                chunksToLoad[x * 5 + z] = stabilizer.isChunkLoadingAt(x, z) ? (byte)1 : 0;
            }
        }
        return new StabilizedChunks(chunksToLoad);
    }

    public boolean loaded(int chunk) {
        return this.chunks[chunk] == 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.chunks, ((StabilizedChunks)o).chunks);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.chunks);
    }
}

