/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import java.util.ArrayList;
import java.util.List;
import mekanism.common.content.matrix.MatrixEnergyContainer;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionPort;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MatrixMultiblockData
extends MultiblockData {
    public static final String STATS_TAB = "stats";
    private final List<MultiblockData.EnergyOutputTarget> energyOutputTargets = new ArrayList<MultiblockData.EnergyOutputTarget>();
    @NotNull
    private final MatrixEnergyContainer energyContainer = new MatrixEnergyContainer(this);
    @ContainerSync(getter="getLastOutput")
    private long clientLastOutput = 0L;
    @ContainerSync(getter="getLastInput")
    private long clientLastInput = 0L;
    @ContainerSync(getter="getEnergy")
    private long clientEnergy = 0L;
    @ContainerSync(tags={"stats"}, getter="getTransferCap")
    private long clientMaxTransfer = 0L;
    @ContainerSync(getter="getStorageCap")
    private long clientMaxEnergy = 0L;
    @ContainerSync(tags={"stats"}, getter="getProviderCount")
    private int clientProviders;
    @ContainerSync(tags={"stats"}, getter="getCellCount")
    private int clientCells;
    @NotNull
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    final EnergyInventorySlot energyInputSlot;
    @NotNull
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    final EnergyInventorySlot energyOutputSlot;

    public MatrixMultiblockData(TileEntityInductionCasing tile) {
        super(tile);
        this.energyContainers.add(this.energyContainer);
        this.energyInputSlot = EnergyInventorySlot.drain(this.energyContainer, this, 146, 21);
        this.inventorySlots.add(this.energyInputSlot);
        this.energyOutputSlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityInductionCasing)tile).getLevel(), this, 146, 51);
        this.inventorySlots.add(this.energyOutputSlot);
        this.energyInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.energyOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.getEnergy(), this.getStorageCap());
    }

    @Override
    protected boolean shouldCap(MultiblockCache.CacheSubstance<?, ?> type) {
        return type != MultiblockCache.CacheSubstance.ENERGY;
    }

    public void addCell(TileEntityInductionCell cell) {
        this.energyContainer.addCell(cell.getBlockPos(), cell);
    }

    public void addProvider(TileEntityInductionProvider provider) {
        this.energyContainer.addProvider(provider.getBlockPos(), provider);
    }

    @NotNull
    public MatrixEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public long getEnergy() {
        return this.isRemote() ? this.clientEnergy : this.energyContainer.getEnergy();
    }

    @Override
    public boolean tick(Level world) {
        boolean ret = super.tick(world);
        this.energyContainer.tick();
        this.energyInputSlot.drainContainer();
        this.energyOutputSlot.fillContainerOrConvert();
        if (!this.energyOutputTargets.isEmpty() && !this.energyContainer.isEmpty()) {
            CableUtils.emit(this.getActiveOutputs(this.energyOutputTargets), this.energyContainer, this.energyContainer.getMaxTransfer());
        }
        if (this.getLastInput() != 0L || this.getLastOutput() != 0L) {
            this.markDirtyComparator(world);
        }
        return ret;
    }

    @Override
    public void remove(Level world, Structure oldStructure) {
        this.energyContainer.invalidate();
        super.remove(world, oldStructure);
    }

    @Override
    protected void updateEjectors(Level world) {
        this.energyOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityInductionPort tile = WorldUtils.getTileEntity(TileEntityInductionPort.class, (BlockGetter)world, valve.location);
            if (tile == null) continue;
            tile.addEnergyTargetCapability(this.energyOutputTargets, valve.side);
        }
    }

    public long getStorageCap() {
        return this.isRemote() ? this.clientMaxEnergy : this.energyContainer.getMaxEnergy();
    }

    @ComputerMethod
    public long getTransferCap() {
        return this.isRemote() ? this.clientMaxTransfer : this.energyContainer.getMaxTransfer();
    }

    @ComputerMethod
    public long getLastInput() {
        return this.isRemote() ? this.clientLastInput : this.energyContainer.getLastInput();
    }

    @ComputerMethod
    public long getLastOutput() {
        return this.isRemote() ? this.clientLastOutput : this.energyContainer.getLastOutput();
    }

    @ComputerMethod(nameOverride="getInstalledCells")
    public int getCellCount() {
        return this.isRemote() ? this.clientCells : this.energyContainer.getCells();
    }

    @ComputerMethod(nameOverride="getInstalledProviders")
    public int getProviderCount() {
        return this.isRemote() ? this.clientProviders : this.energyContainer.getProviders();
    }
}

