/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SorterTagFilter
extends SorterFilter<SorterTagFilter>
implements ITagFilter<SorterTagFilter> {
    public static final MapCodec<SorterTagFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> SorterTagFilter.baseSorterCodec(instance).and((App)Codec.STRING.fieldOf("tag").forGetter(SorterTagFilter::getTagName)).apply((Applicative)instance, SorterTagFilter::new));
    public static final StreamCodec<ByteBuf, SorterTagFilter> STREAM_CODEC = StreamCodec.composite(SorterTagFilter.baseSorterStreamCodec(SorterTagFilter::new), Function.identity(), (StreamCodec)ByteBufCodecs.STRING_UTF8, SorterTagFilter::getTagName, (filter, tagName) -> {
        filter.tagName = tagName;
        return filter;
    });
    private String tagName;

    public SorterTagFilter() {
    }

    protected SorterTagFilter(boolean enabled, boolean allowDefault, boolean sizeMode, int min, int max, Optional<EnumColor> color, String tagName) {
        super(enabled, allowDefault, sizeMode, min, max, color.orElse(null));
        this.tagName = tagName;
    }

    public SorterTagFilter(SorterTagFilter filter) {
        super(filter);
        this.tagName = filter.tagName;
    }

    @Override
    public Finder getFinder() {
        return Finder.tag(this.tagName);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.tagName.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterTagFilter other = (SorterTagFilter)o;
        return this.tagName.equals(other.tagName);
    }

    @Override
    public SorterTagFilter clone() {
        return new SorterTagFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_TAG_FILTER;
    }

    @Override
    public void setTagName(String name) {
        this.tagName = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }
}

