/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.basic.BasicCompressingRecipe;
import mekanism.api.recipes.basic.BasicInjectingRecipe;
import mekanism.api.recipes.basic.BasicMetallurgicInfuserRecipe;
import mekanism.api.recipes.basic.BasicPaintingRecipe;
import mekanism.api.recipes.basic.BasicPurifyingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackChemicalToItemStack")
public abstract class ItemStackChemicalToItemStackRecipeManager
extends MekanismRecipeManager<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe> {
    protected ItemStackChemicalToItemStackRecipeManager(IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack output, boolean perTickUsage) {
        this.addRecipe(name, this.makeRecipe(itemInput, chemicalInput, output, perTickUsage));
    }

    public final ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack output, boolean perTickUsage) {
        return this.makeRecipe(itemInput, chemicalInput, this.getAndValidateNotEmpty(output), perTickUsage);
    }

    protected abstract ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount var1, ChemicalStackIngredient var2, ItemStack var3, boolean var4);

    @Override
    protected String describeOutputs(ItemStackChemicalToItemStackRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), ItemStackUtil::getCommandString);
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackChemicalToItemStack.Painting")
    public static class PaintingRecipeManager
    extends ItemStackChemicalToItemStackRecipeManager {
        public static final PaintingRecipeManager INSTANCE = new PaintingRecipeManager();

        private PaintingRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.PAINTING);
        }

        @Override
        protected ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ItemStack output, boolean perTickUsage) {
            return new BasicPaintingRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, output, perTickUsage);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackChemicalToItemStack.MetallurgicInfusing")
    public static class MetallurgicInfuserRecipeManager
    extends ItemStackChemicalToItemStackRecipeManager {
        public static final MetallurgicInfuserRecipeManager INSTANCE = new MetallurgicInfuserRecipeManager();

        private MetallurgicInfuserRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.METALLURGIC_INFUSING);
        }

        @Override
        protected ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ItemStack output, boolean perTickUsage) {
            return new BasicMetallurgicInfuserRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, output, perTickUsage);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackChemicalToItemStack.Purifying")
    public static class PurificationRecipeManager
    extends ItemStackChemicalToItemStackRecipeManager {
        public static final PurificationRecipeManager INSTANCE = new PurificationRecipeManager();

        private PurificationRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.PURIFYING);
        }

        @Override
        protected ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ItemStack output, boolean perTickUsage) {
            return new BasicPurifyingRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, output, perTickUsage);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackChemicalToItemStack.Injecting")
    public static class ChemicalInjectionRecipeManager
    extends ItemStackChemicalToItemStackRecipeManager {
        public static final ChemicalInjectionRecipeManager INSTANCE = new ChemicalInjectionRecipeManager();

        private ChemicalInjectionRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.INJECTING);
        }

        @Override
        protected ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ItemStack output, boolean perTickUsage) {
            return new BasicInjectingRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, output, perTickUsage);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackChemicalToItemStack.Compressing")
    public static class OsmiumCompressorRecipeManager
    extends ItemStackChemicalToItemStackRecipeManager {
        public static final OsmiumCompressorRecipeManager INSTANCE = new OsmiumCompressorRecipeManager();

        private OsmiumCompressorRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.COMPRESSING);
        }

        @Override
        protected ItemStackChemicalToItemStackRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, ItemStack output, boolean perTickUsage) {
            return new BasicCompressingRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, output, perTickUsage);
        }
    }
}

