/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.framedblocks;

import mekanism.api.chemical.Chemical;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.integration.framedblocks.ChemicalCamoClientHandler;
import mekanism.common.integration.framedblocks.ChemicalParticleOptions;
import mekanism.common.registration.impl.FluidDeferredRegister;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.CamoClientHandler;
import xfacthd.framedblocks.api.camo.CamoContent;

final class ChemicalCamoContent
extends CamoContent<ChemicalCamoContent> {
    private final Holder<Chemical> chemicalHolder;
    private final MapColor mapColor;

    ChemicalCamoContent(Holder<Chemical> chemicalHolder) {
        this.chemicalHolder = chemicalHolder;
        this.mapColor = FluidDeferredRegister.getClosestColor(((Chemical)this.chemicalHolder.value()).getColorRepresentation());
    }

    Holder<Chemical> getChemicalHolder() {
        return this.chemicalHolder;
    }

    public boolean propagatesSkylightDown(BlockGetter level, BlockPos pos) {
        return true;
    }

    public float getExplosionResistance(BlockGetter level, BlockPos pos, Explosion explosion) {
        return 0.0f;
    }

    public boolean isFlammable(BlockGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int getFlammability(BlockGetter level, BlockPos pos, Direction side) {
        return 0;
    }

    public int getFireSpreadSpeed(BlockGetter level, BlockPos pos, Direction side) {
        return 0;
    }

    public float getShadeBrightness(BlockGetter level, BlockPos pos, float frameShade) {
        return 1.0f;
    }

    public int getLightEmission() {
        return 0;
    }

    public boolean isEmissive() {
        return false;
    }

    public SoundType getSoundType() {
        return SoundType.WET_GRASS;
    }

    public boolean shouldDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public float getFriction(LevelReader level, BlockPos pos, @Nullable Entity entity, float frameFriction) {
        return frameFriction;
    }

    public TriState canSustainPlant(BlockGetter level, BlockPos pos, Direction side, BlockState plant) {
        return TriState.DEFAULT;
    }

    public boolean canEntityDestroy(BlockGetter level, BlockPos pos, Entity entity) {
        return true;
    }

    @Nullable
    public MapColor getMapColor(BlockGetter level, BlockPos pos) {
        return this.mapColor;
    }

    public int getTintColor(BlockAndTintGetter blockAndTintGetter, BlockPos pos, int tintIdx) {
        return ((Chemical)this.chemicalHolder.value()).getTint();
    }

    public Integer getBeaconColorMultiplier(LevelReader levelReader, BlockPos pos, BlockPos beaconPos) {
        return ((Chemical)this.chemicalHolder.value()).getColorRepresentation();
    }

    public boolean isSolid(BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean canOcclude() {
        return false;
    }

    public BlockState getAsBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState getAppearanceState() {
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isOccludedBy(BlockState adjState, BlockGetter level, BlockPos pos, BlockPos adjPos) {
        return adjState.isSolidRender(level, pos);
    }

    public boolean isOccludedBy(CamoContent<?> adjCamo, BlockGetter level, BlockPos pos, BlockPos adjPos) {
        return adjCamo.isSolid(level, pos) || this.equals(adjCamo);
    }

    public boolean occludes(BlockState adjState, BlockGetter level, BlockPos pos, BlockPos adjPos) {
        return false;
    }

    public ParticleOptions makeRunningLandingParticles(BlockPos pos) {
        return new ChemicalParticleOptions(this.chemicalHolder);
    }

    public String getCamoId() {
        return this.chemicalHolder.getRegisteredName();
    }

    public MutableComponent getCamoName() {
        return TextComponentUtil.build(this.chemicalHolder);
    }

    public CamoClientHandler<ChemicalCamoContent> getClientHandler() {
        return ChemicalCamoClientHandler.INSTANCE;
    }

    public int hashCode() {
        return this.chemicalHolder.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ChemicalCamoContent.class) {
            return false;
        }
        return this.chemicalHolder.is(((ChemicalCamoContent)((Object)obj)).chemicalHolder);
    }

    public String toString() {
        return "ChemicalCamoContent{" + this.getCamoId() + "}";
    }
}

