/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.wthit;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mekanism.common.integration.lookingat.ChemicalElement;
import mekanism.common.integration.lookingat.EnergyElement;
import mekanism.common.integration.lookingat.FluidElement;
import mekanism.common.integration.lookingat.ILookingAtElement;
import mekanism.common.integration.lookingat.SimpleLookingAtHelper;
import mekanism.common.integration.lookingat.TextElement;
import mekanism.common.integration.lookingat.wthit.MekanismWTHITPlugin;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;

public class WTHITLookingAtHelper
extends SimpleLookingAtHelper
implements IData {
    public static final IData.Type<WTHITLookingAtHelper> TYPE = () -> MekanismWTHITPlugin.MEK_DATA;
    public static final StreamCodec<RegistryFriendlyByteBuf, WTHITLookingAtHelper> STREAM_CODEC = LookingAtTypes.STREAM_CODEC.cast().dispatch(LookingAtTypes::getType, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> EnergyElement.STREAM_CODEC;
        case 1 -> FluidElement.STREAM_CODEC;
        case 2 -> ChemicalElement.STREAM_CODEC;
        case 3 -> TextElement.STREAM_CODEC;
    }).apply(ByteBufCodecs.list()).map(WTHITLookingAtHelper::new, helper -> helper.elements);

    public WTHITLookingAtHelper() {
        this(new ArrayList<ILookingAtElement>());
    }

    private WTHITLookingAtHelper(List<ILookingAtElement> elements) {
        super(elements);
    }

    public IData.Type<? extends IData> type() {
        return TYPE;
    }

    private static enum LookingAtTypes {
        ENERGY,
        FLUID,
        CHEMICAL,
        COMPONENT;

        public static final IntFunction<LookingAtTypes> BY_ID;
        public static final StreamCodec<ByteBuf, LookingAtTypes> STREAM_CODEC;

        public static LookingAtTypes getType(ILookingAtElement element) {
            ILookingAtElement iLookingAtElement = element;
            Objects.requireNonNull(iLookingAtElement);
            ILookingAtElement iLookingAtElement2 = iLookingAtElement;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextElement.class, EnergyElement.class, FluidElement.class, ChemicalElement.class}, (Object)iLookingAtElement2, n)) {
                case 0 -> {
                    TextElement textElement = (TextElement)iLookingAtElement2;
                    yield COMPONENT;
                }
                case 1 -> {
                    EnergyElement energyElement = (EnergyElement)iLookingAtElement2;
                    yield ENERGY;
                }
                case 2 -> {
                    FluidElement fluidElement = (FluidElement)iLookingAtElement2;
                    yield FLUID;
                }
                case 3 -> {
                    ChemicalElement chemicalElement = (ChemicalElement)iLookingAtElement2;
                    yield CHEMICAL;
                }
                default -> throw new EncoderException("Unknown looking at type for " + element.getClass().getSimpleName());
            };
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])LookingAtTypes.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

