/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IDisableableEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.MathUtils;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IHasConditionalAttributes;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.radial.IRadialModeItem;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.NotNull;

public class ItemAtomicDisassembler
extends ItemEnergized
implements IItemHUDProvider,
IRadialModeItem<DisassemblerMode>,
IHasConditionalAttributes {
    public static final Set<ItemAbility> ALWAYS_SUPPORTED_ACTIONS = Set.of(ItemAbilities.AXE_DIG, ItemAbilities.HOE_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.PICKAXE_DIG, ItemAbilities.SWORD_DIG);
    private static final Lazy<RadialData<DisassemblerMode>> LAZY_RADIAL_DATA = Lazy.of(() -> IRadialDataHelper.INSTANCE.dataForEnum(Mekanism.rl("disassembler_mode"), DisassemblerMode.NORMAL));

    public static ItemStack fullyChargedStack() {
        return StorageUtils.getFilledEnergyVariant(MekanismItems.ATOMIC_DISASSEMBLER);
    }

    public ItemAtomicDisassembler(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE).setNoRepair().stacksTo(1).component(MekanismDataComponents.DISASSEMBLER_MODE, (Object)DisassemblerMode.NORMAL).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops(MekanismTags.Blocks.INCORRECT_FOR_DISASSEMBLER), new Tool.Rule((HolderSet)new AnyHolderSet(BuiltInRegistries.BLOCK.asLookup()), Optional.empty(), Optional.of(true))), 1.0f, 0)));
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        DisassemblerMode mode = (DisassemblerMode)this.getMode(stack);
        tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.INDIGO, mode));
        tooltip.add((Component)MekanismLang.DISASSEMBLER_EFFICIENCY.translateColored(EnumColor.INDIGO, mode.getEfficiency()));
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility action) {
        IEnergyContainer energyContainer;
        if (ALWAYS_SUPPORTED_ACTIONS.contains(action) && (energyContainer = StorageUtils.getEnergyContainer(stack, 0)) != null) {
            long energyAvailable;
            long energyRequired = this.getDestroyEnergy(stack, 0.0f);
            return energyRequired <= (energyAvailable = energyContainer.getEnergy()) || (double)energyAvailable / (double)energyRequired > (double)1.0E-6f;
        }
        return false;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null && !energyContainer.isEmpty()) {
            energyContainer.extract(MekanismConfig.gear.disassemblerEnergyUsageWeapon.get(), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        long energyRequired = this.getDestroyEnergy(stack, state.destroySpeed);
        long energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable < energyRequired) {
            return (float)((double)DisassemblerMode.NORMAL.getEfficiency() * ((double)energyAvailable / (double)energyRequired));
        }
        return ((DisassemblerMode)this.getMode(stack)).getEfficiency();
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            ServerPlayer player;
            long baseDestroyEnergy = this.getDestroyEnergy(stack);
            long energyRequired = ItemAtomicDisassembler.getDestroyEnergy(baseDestroyEnergy, state.getDestroySpeed((BlockGetter)world, pos));
            energyContainer.extract(energyRequired, Action.EXECUTE, AutomationType.MANUAL);
            if (!world.isClientSide && entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isCreative() && this.getMode(stack) == DisassemblerMode.VEIN && energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL) == energyRequired && ModuleVeinMiningUnit.canVeinBlock(state) && state.is(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE)) {
                Object2IntMap<BlockPos> found = ModuleVeinMiningUnit.findPositions(world, Map.of(pos, state), 0, (Reference2BooleanMap<Block>)Reference2BooleanMaps.singleton((Object)state.getBlock(), (boolean)true));
                MekanismUtils.veinMineArea(energyContainer, energyRequired, 0L, baseDestroyEnergy, world, pos, player, stack, this, found, (base, hardness) -> 0L, (base, hardness, distance, bs) -> MathUtils.ceilToLong((double)ItemAtomicDisassembler.getDestroyEnergy(base, hardness) * (0.5 * Math.pow(distance, 1.5))));
            }
        }
        return true;
    }

    private long getDestroyEnergy(ItemStack itemStack, float hardness) {
        return ItemAtomicDisassembler.getDestroyEnergy(this.getDestroyEnergy(itemStack), hardness);
    }

    private static long getDestroyEnergy(long baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? Math.max(baseDestroyEnergy / 2L, 1L) : baseDestroyEnergy;
    }

    private long getDestroyEnergy(ItemStack itemStack) {
        return MathUtils.multiplyClamped(MekanismConfig.gear.disassemblerEnergyUsage.get(), ((DisassemblerMode)this.getMode(itemStack)).getEfficiency());
    }

    @Override
    public DataComponentType<DisassemblerMode> getModeDataType() {
        return (DataComponentType)MekanismDataComponents.DISASSEMBLER_MODE.get();
    }

    @Override
    public DisassemblerMode getDefaultMode() {
        return DisassemblerMode.NORMAL;
    }

    @Override
    @NotNull
    public RadialData<DisassemblerMode> getRadialData(ItemStack stack) {
        return (RadialData)LAZY_RADIAL_DATA.get();
    }

    @Override
    public void adjustAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        long energy = energyContainer == null ? 0L : energyContainer.getEnergy();
        long energyCost = MekanismConfig.gear.disassemblerEnergyUsageWeapon.get();
        double damage = MekanismConfig.gear.disassemblerMaxDamage.get();
        double attackSpeed = MekanismConfig.gear.disassemblerAttackSpeed.get();
        if (energy < energyCost) {
            int minDamage = MekanismConfig.gear.disassemblerMinDamage.get();
            int damageDifference = MekanismConfig.gear.disassemblerMaxDamage.get() - minDamage;
            damage = (double)minDamage + (double)damageDifference * MathUtils.divideToLevel(energy, energyCost);
        }
        event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        DisassemblerMode mode = (DisassemblerMode)this.getMode(stack);
        list.add((Component)MekanismLang.MODE.translateColored(EnumColor.GRAY, EnumColor.INDIGO, mode));
        list.add((Component)MekanismLang.DISASSEMBLER_EFFICIENCY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, mode.getEfficiency()));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        DisassemblerMode newMode;
        DisassemblerMode mode = (DisassemblerMode)this.getMode(stack);
        if (mode != (newMode = (DisassemblerMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            displayChange.sendMessage(player, newMode, m -> MekanismLang.DISASSEMBLER_MODE_CHANGE.translate(EnumColor.INDIGO, m, EnumColor.AQUA, m.getEfficiency()));
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        DisassemblerMode mode = (DisassemblerMode)this.getMode(stack);
        return MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.INDIGO, mode, EnumColor.AQUA, mode.getEfficiency());
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return this.isEnchantable(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.isPrimaryItemFor(stack, enchantment);
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.supportsEnchantment(stack, enchantment);
    }

    @NothingNullByDefault
    public static enum DisassemblerMode implements IDisableableEnum<DisassemblerMode>,
    IHasTextComponent.IHasEnumNameTextComponent,
    IRadialMode,
    StringRepresentable
    {
        NORMAL(MekanismLang.RADIAL_EXCAVATION_SPEED_NORMAL, 20, ConstantPredicates.ALWAYS_TRUE, EnumColor.BRIGHT_GREEN, ModuleExcavationEscalationUnit.ExcavationMode.NORMAL.icon()),
        SLOW(MekanismLang.RADIAL_EXCAVATION_SPEED_SLOW, 8, MekanismConfig.gear.disassemblerSlowMode, EnumColor.PINK, ModuleExcavationEscalationUnit.ExcavationMode.SLOW.icon()),
        FAST(MekanismLang.RADIAL_EXCAVATION_SPEED_FAST, 128, MekanismConfig.gear.disassemblerFastMode, EnumColor.RED, ModuleExcavationEscalationUnit.ExcavationMode.EXTREME.icon()),
        VEIN(MekanismLang.RADIAL_VEIN_NORMAL, 20, MekanismConfig.gear.disassemblerVeinMining, EnumColor.AQUA, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "vein_normal.png")),
        OFF(MekanismLang.RADIAL_EXCAVATION_SPEED_OFF, 0, ConstantPredicates.ALWAYS_TRUE, EnumColor.WHITE, ModuleExcavationEscalationUnit.ExcavationMode.OFF.icon());

        public static final Codec<DisassemblerMode> CODEC;
        public static final IntFunction<DisassemblerMode> BY_ID;
        public static final StreamCodec<ByteBuf, DisassemblerMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final BooleanSupplier checkEnabled;
        private final ILangEntry langEntry;
        private final int efficiency;
        private final EnumColor color;
        private final ResourceLocation icon;

        private DisassemblerMode(ILangEntry langEntry, int efficiency, BooleanSupplier checkEnabled, EnumColor color, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.efficiency = efficiency;
            this.checkEnabled = checkEnabled;
            this.color = color;
            this.icon = icon;
        }

        @Override
        public DisassemblerMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate(this.color);
        }

        @Override
        @NotNull
        public Component sliceName() {
            return this.getTextComponent();
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        @Override
        public boolean isEnabled() {
            return this.checkEnabled.getAsBoolean();
        }

        @Override
        @NotNull
        public ResourceLocation icon() {
            return this.icon;
        }

        @Override
        public EnumColor color() {
            return this.color;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(DisassemblerMode::values).xmap(mode -> mode.isEnabled() ? mode : NORMAL, Function.identity());
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DisassemblerMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

