/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import java.util.List;
import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.ClientSidePersonalStorageInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.tile.TileEntityPersonalStorage;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.fml.util.thread.EffectiveSide;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class PersonalStorageContentsLootFunction
implements LootItemFunction {
    public static final PersonalStorageContentsLootFunction INSTANCE = new PersonalStorageContentsLootFunction();

    private PersonalStorageContentsLootFunction() {
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }

    public LootItemFunctionType<PersonalStorageContentsLootFunction> getType() {
        return (LootItemFunctionType)MekanismLootFunctions.PERSONAL_STORAGE.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        TileEntityPersonalStorage personalStorage;
        BlockEntity blockEntity = (BlockEntity)lootContext.getParam(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof TileEntityPersonalStorage && !(personalStorage = (TileEntityPersonalStorage)blockEntity).isInventoryEmpty()) {
            List<IInventorySlot> tileSlots = personalStorage.getInventorySlots(null);
            AbstractPersonalStorageItemInventory destInv = EffectiveSide.get().isClient() ? new ClientSidePersonalStorageInventory() : PersonalStorageManager.getInventoryFor(stack).orElseThrow(() -> new IllegalStateException("Inventory not available?!"));
            for (int i = 0; i < tileSlots.size(); ++i) {
                IInventorySlot tileSlot = tileSlots.get(i);
                if (tileSlot.isEmpty()) continue;
                destInv.setStackInSlot(i, tileSlot.getStack().copy());
            }
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }
}

