/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import mekanism.common.Mekanism;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class FieldReflectionHelper<CLASS, TYPE> {
    private final Class<CLASS> clazz;
    private final String fieldName;
    private final Supplier<TYPE> fallback;
    private Field field;

    public FieldReflectionHelper(Class<CLASS> clazz, String fieldName, Supplier<TYPE> fallback) {
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.fallback = fallback;
    }

    public TYPE getValue(CLASS input) {
        if (this.field == null) {
            try {
                this.field = ObfuscationReflectionHelper.findField(this.clazz, (String)this.fieldName);
            }
            catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
                Mekanism.logger.error("Error getting {} {} field.", new Object[]{this.clazz.getSimpleName(), this.fieldName, e});
                return this.fallback.get();
            }
        }
        try {
            return (TYPE)this.field.get(input);
        }
        catch (IllegalAccessException e) {
            Mekanism.logger.error("Error accessing {} {} field.", new Object[]{this.clazz.getSimpleName(), this.fieldName, e});
            return this.fallback.get();
        }
    }

    public void transformValue(CLASS input, Predicate<TYPE> shouldTransform, UnaryOperator<TYPE> valueTransformer) {
        Object value = this.getValue(input);
        if (this.field != null && shouldTransform.test(value)) {
            value = valueTransformer.apply(value);
            try {
                this.field.set(input, value);
            }
            catch (IllegalAccessException e) {
                Mekanism.logger.error("Error accessing {} {} field.", new Object[]{this.clazz.getSimpleName(), this.fieldName, e});
            }
        }
    }
}

