/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.stream.Stream;

public record SequencedCollectionCodec<E>(Codec<E> elementCodec, int minSize, int maxSize) implements Codec<SequencedCollection<E>>
{
    public SequencedCollectionCodec(Codec<E> elementCodec) {
        this(elementCodec, 0, Integer.MAX_VALUE);
    }

    private <R> DataResult<R> createTooShortError(int size) {
        return DataResult.error(() -> "List is too short: " + size + ", expected range [" + this.minSize + "-" + this.maxSize + "]");
    }

    private <R> DataResult<R> createTooLongError(int size) {
        return DataResult.error(() -> "List is too long: " + size + ", expected range [" + this.minSize + "-" + this.maxSize + "]");
    }

    public <T> DataResult<T> encode(SequencedCollection<E> input, DynamicOps<T> ops, T prefix) {
        if (input.size() < this.minSize) {
            return this.createTooShortError(input.size());
        }
        if (input.size() > this.maxSize) {
            return this.createTooLongError(input.size());
        }
        ListBuilder builder = ops.listBuilder();
        for (Object element : input) {
            builder.add(this.elementCodec.encodeStart(ops, element));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<SequencedCollection<E>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            DecoderState decoder = new DecoderState(ops);
            stream.accept(decoder::accept);
            return decoder.build();
        });
    }

    @Override
    public String toString() {
        return "ListCodec[" + String.valueOf(this.elementCodec) + "]";
    }

    private class DecoderState<T> {
        private static final DataResult<Unit> INITIAL_RESULT = DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable());
        private final DynamicOps<T> ops;
        private final List<E> elements = new ArrayList();
        private final Stream.Builder<T> failed = Stream.builder();
        private DataResult<Unit> result = INITIAL_RESULT;
        private int totalCount;

        private DecoderState(DynamicOps<T> ops) {
            this.ops = ops;
        }

        public void accept(T value) {
            ++this.totalCount;
            if (this.elements.size() >= SequencedCollectionCodec.this.maxSize) {
                this.failed.add(value);
                return;
            }
            DataResult elementResult = SequencedCollectionCodec.this.elementCodec.decode(this.ops, value);
            elementResult.error().ifPresent(error -> this.failed.add(value));
            elementResult.resultOrPartial().ifPresent(pair -> this.elements.add(pair.getFirst()));
            this.result = this.result.apply2stable((result, element) -> result, elementResult);
        }

        public DataResult<Pair<SequencedCollection<E>, T>> build() {
            if (this.elements.size() < SequencedCollectionCodec.this.minSize) {
                return SequencedCollectionCodec.this.createTooShortError(this.elements.size());
            }
            Object errors = this.ops.createList(this.failed.build());
            Pair pair = Pair.of(List.copyOf(this.elements), (Object)errors);
            if (this.totalCount > SequencedCollectionCodec.this.maxSize) {
                this.result = SequencedCollectionCodec.this.createTooLongError(this.totalCount);
            }
            return this.result.map(ignored -> pair).setPartial((Object)pair);
        }
    }
}

