/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import io.netty.buffer.ByteBuf;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketLightningRender(LightningPreset preset, int renderer, Vec3 start, Vec3 end, int segments) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketLightningRender> TYPE = new CustomPacketPayload.Type(Mekanism.rl("render_bolt"));
    public static final StreamCodec<ByteBuf, PacketLightningRender> STREAM_CODEC = StreamCodec.composite(LightningPreset.STREAM_CODEC, PacketLightningRender::preset, (StreamCodec)ByteBufCodecs.VAR_INT, PacketLightningRender::renderer, PacketUtils.VEC3_STREAM_CODEC, PacketLightningRender::start, PacketUtils.VEC3_STREAM_CODEC, PacketLightningRender::end, (StreamCodec)ByteBufCodecs.VAR_INT, PacketLightningRender::segments, PacketLightningRender::new);

    @NotNull
    public CustomPacketPayload.Type<PacketLightningRender> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        if (this.preset.shouldAdd.getAsBoolean()) {
            RenderTickHandler.renderBolt(this.renderer, this.preset.boltCreator.create(this.start, this.end, this.segments));
        }
    }

    public static enum LightningPreset {
        MAGNETIC_ATTRACTION(MekanismConfig.client.renderMagneticAttractionParticles, (start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.04f).lifespan(8).spawn(BoltEffect.SpawnFunction.noise(8.0f, 4.0f))),
        TOOL_AOE(MekanismConfig.client.renderToolAOEParticles, (start, end, segments) -> new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start, end, segments).size(0.015f).lifespan(12).spawn(BoltEffect.SpawnFunction.NO_DELAY));

        public static final IntFunction<LightningPreset> BY_ID;
        public static final StreamCodec<ByteBuf, LightningPreset> STREAM_CODEC;
        private final BooleanSupplier shouldAdd;
        private final BoltCreator boltCreator;

        private LightningPreset(BooleanSupplier shouldAdd, BoltCreator boltCreator) {
            this.shouldAdd = shouldAdd;
            this.boltCreator = boltCreator;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])LightningPreset.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    @FunctionalInterface
    public static interface BoltCreator {
        public BoltEffect create(Vec3 var1, Vec3 var2, int var3);
    }
}

