/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.button;

import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketEntityButtonPress(ClickedEntityButton buttonClicked, int entityID) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketEntityButtonPress> TYPE = new CustomPacketPayload.Type(Mekanism.rl("entity_button"));
    public static final StreamCodec<ByteBuf, PacketEntityButtonPress> STREAM_CODEC = StreamCodec.composite(ClickedEntityButton.STREAM_CODEC, PacketEntityButtonPress::buttonClicked, (StreamCodec)ByteBufCodecs.VAR_INT, PacketEntityButtonPress::entityID, PacketEntityButtonPress::new);

    public PacketEntityButtonPress(ClickedEntityButton buttonClicked, Entity entity) {
        this(buttonClicked, entity.getId());
    }

    @NotNull
    public CustomPacketPayload.Type<PacketEntityButtonPress> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        Entity entity = player.level().getEntity(this.entityID);
        MenuProvider provider = this.buttonClicked.getProvider(entity);
        if (provider != null) {
            player.openMenu(provider, buf -> {
                buf.writeVarInt(this.entityID);
                this.buttonClicked.encodeExtraData((RegistryFriendlyByteBuf)buf, entity);
            });
        }
    }

    public static enum ClickedEntityButton {
        ROBIT_CRAFTING(entity -> MekanismContainerTypes.CRAFTING_ROBIT.getProvider(MekanismLang.ROBIT_CRAFTING, entity)),
        ROBIT_INVENTORY(entity -> MekanismContainerTypes.INVENTORY_ROBIT.getProvider(MekanismLang.ROBIT_INVENTORY, entity)),
        ROBIT_MAIN(entity -> MekanismContainerTypes.MAIN_ROBIT.getProvider(MekanismLang.ROBIT, entity)),
        ROBIT_REPAIR(entity -> MekanismContainerTypes.REPAIR_ROBIT.getProvider(MekanismLang.ROBIT_REPAIR, entity)),
        ROBIT_SMELTING(entity -> MekanismContainerTypes.SMELTING_ROBIT.getProvider(MekanismLang.ROBIT_SMELTING, entity));

        public static final IntFunction<ClickedEntityButton> BY_ID;
        public static final StreamCodec<ByteBuf, ClickedEntityButton> STREAM_CODEC;
        private final Function<Entity, @Nullable MenuProvider> providerFromEntity;
        @Nullable
        private final BiConsumer<RegistryFriendlyByteBuf, Entity> extraEncodingData;

        private ClickedEntityButton(Function<Entity, MenuProvider> providerFromEntity) {
            this(providerFromEntity, null);
        }

        private ClickedEntityButton(Function<Entity, MenuProvider> providerFromEntity, BiConsumer<RegistryFriendlyByteBuf, Entity> extraEncodingData) {
            this.providerFromEntity = providerFromEntity;
            this.extraEncodingData = extraEncodingData;
        }

        @Nullable
        @Contract(value="null -> null")
        public MenuProvider getProvider(@Nullable Entity entity) {
            return entity == null ? null : this.providerFromEntity.apply(entity);
        }

        private void encodeExtraData(RegistryFriendlyByteBuf buffer, Entity entity) {
            if (this.extraEncodingData != null) {
                this.extraEncodingData.accept(buffer, entity);
            }
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ClickedEntityButton.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

