/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class DoubleInputRecipeCache<INPUT_A, INGREDIENT_A extends InputIngredient<INPUT_A>, INPUT_B, INGREDIENT_B extends InputIngredient<INPUT_B>, RECIPE extends MekanismRecipe<?>, CACHE_A extends IInputCache<INPUT_A, INGREDIENT_A, RECIPE>, CACHE_B extends IInputCache<INPUT_B, INGREDIENT_B, RECIPE>>
extends AbstractInputRecipeCache<RECIPE> {
    private final Set<RECIPE> complexIngredientA = new HashSet<RECIPE>();
    private final Set<RECIPE> complexIngredientB = new HashSet<RECIPE>();
    private final Set<RECIPE> complexRecipes = new HashSet<RECIPE>();
    private final Function<RECIPE, INGREDIENT_A> inputAExtractor;
    private final Function<RECIPE, INGREDIENT_B> inputBExtractor;
    private final CACHE_A cacheA;
    private final CACHE_B cacheB;

    protected DoubleInputRecipeCache(MekanismRecipeType<?, RECIPE, ?> recipeType, Function<RECIPE, INGREDIENT_A> inputAExtractor, CACHE_A cacheA, Function<RECIPE, INGREDIENT_B> inputBExtractor, CACHE_B cacheB) {
        super(recipeType);
        this.inputAExtractor = inputAExtractor;
        this.inputBExtractor = inputBExtractor;
        this.cacheA = cacheA;
        this.cacheB = cacheB;
    }

    @Override
    public void clear() {
        super.clear();
        this.cacheA.clear();
        this.cacheB.clear();
        this.complexIngredientA.clear();
        this.complexIngredientB.clear();
        this.complexRecipes.clear();
    }

    public boolean containsInputA(@Nullable Level world, INPUT_A input) {
        return this.containsInput(world, input, this.inputAExtractor, this.cacheA, this.complexIngredientA);
    }

    public boolean containsInputB(@Nullable Level world, INPUT_B input) {
        return this.containsInput(world, input, this.inputBExtractor, this.cacheB, this.complexIngredientB);
    }

    public boolean containsInputAB(@Nullable Level world, INPUT_A inputA, INPUT_B inputB) {
        return this.containsPairing(world, inputA, this.inputAExtractor, this.cacheA, this.complexIngredientA, inputB, this.inputBExtractor, this.cacheB, this.complexIngredientB);
    }

    public boolean containsInputBA(@Nullable Level world, INPUT_A inputA, INPUT_B inputB) {
        return this.containsPairing(world, inputB, this.inputBExtractor, this.cacheB, this.complexIngredientB, inputA, this.inputAExtractor, this.cacheA, this.complexIngredientA);
    }

    @Nullable
    public RECIPE findFirstRecipe(@Nullable Level world, INPUT_A inputA, INPUT_B inputB) {
        return this.findFirstRecipe(world, inputA, inputB, true);
    }

    @Nullable
    public RECIPE findFirstRecipe(@Nullable Level world, INPUT_A inputA, INPUT_B inputB, boolean useCacheA) {
        if (this.cacheA.isEmpty(inputA) || this.cacheB.isEmpty(inputB)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        Object recipe = useCacheA ? this.findFirstRecipe(inputA, inputB, this.cacheA.getRecipes(inputA)) : this.findFirstRecipe(inputA, inputB, this.cacheB.getRecipes(inputB));
        return recipe == null ? this.findFirstRecipe(inputA, inputB, this.complexRecipes) : recipe;
    }

    @Nullable
    private RECIPE findFirstRecipe(INPUT_A inputA, INPUT_B inputB, Iterable<RECIPE> recipes) {
        for (MekanismRecipe recipe : recipes) {
            if (!((BiPredicate)((Object)recipe)).test(inputA, inputB)) continue;
            return (RECIPE)recipe;
        }
        return null;
    }

    @Nullable
    public <DATA> RECIPE findTypeBasedRecipe(@Nullable Level world, INPUT_A inputA, INPUT_B inputB, DATA data, CheckRecipeType<INPUT_A, INPUT_B, RECIPE, DATA> matchCriteria) {
        if (this.cacheA.isEmpty(inputA)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        if (this.cacheB.isEmpty(inputB)) {
            for (MekanismRecipe recipe : this.cacheA.getRecipes(inputA)) {
                if (!matchCriteria.testType(recipe, inputA, inputB, data)) continue;
                return (RECIPE)recipe;
            }
            for (MekanismRecipe complexRecipe : this.complexRecipes) {
                if (!((InputIngredient)this.inputAExtractor.apply(complexRecipe)).testType(inputA) || !matchCriteria.testType(complexRecipe, inputA, inputB, data)) continue;
                return (RECIPE)complexRecipe;
            }
        } else {
            for (MekanismRecipe recipe : this.cacheA.getRecipes(inputA)) {
                if (!((InputIngredient)this.inputBExtractor.apply(recipe)).testType(inputB) || !matchCriteria.testType(recipe, inputA, inputB, data)) continue;
                return (RECIPE)recipe;
            }
            for (MekanismRecipe complexRecipe : this.complexRecipes) {
                if (!((InputIngredient)this.inputAExtractor.apply(complexRecipe)).testType(inputA) || !((InputIngredient)this.inputBExtractor.apply(complexRecipe)).testType(inputB) || !matchCriteria.testType(complexRecipe, inputA, inputB, data)) continue;
                return (RECIPE)complexRecipe;
            }
        }
        return null;
    }

    @Override
    protected void initCache(List<RecipeHolder<RECIPE>> recipes) {
        for (RecipeHolder<RECIPE> recipeHolder : recipes) {
            MekanismRecipe recipe = (MekanismRecipe)recipeHolder.value();
            boolean complexA = this.cacheA.mapInputs((MekanismRecipe)recipe, (InputIngredient)((InputIngredient)this.inputAExtractor.apply(recipe)));
            boolean complexB = this.cacheB.mapInputs((MekanismRecipe)recipe, (InputIngredient)((InputIngredient)this.inputBExtractor.apply(recipe)));
            if (complexA) {
                this.complexIngredientA.add(recipe);
            }
            if (complexB) {
                this.complexIngredientB.add(recipe);
            }
            if (!complexA && !complexB) continue;
            this.complexRecipes.add(recipe);
        }
    }

    @FunctionalInterface
    public static interface CheckRecipeType<INPUT_A, INPUT_B, RECIPE extends MekanismRecipe<?>, DATA> {
        public boolean testType(RECIPE var1, INPUT_A var2, INPUT_B var3, DATA var4);
    }

    public static abstract class DoubleSameInputRecipeCache<INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe<?>, CACHE extends IInputCache<INPUT, INGREDIENT, RECIPE>>
    extends DoubleInputRecipeCache<INPUT, INGREDIENT, INPUT, INGREDIENT, RECIPE, CACHE, CACHE> {
        protected DoubleSameInputRecipeCache(MekanismRecipeType<?, RECIPE, ?> recipeType, Function<RECIPE, INGREDIENT> inputAExtractor, Function<RECIPE, INGREDIENT> inputBExtractor, Supplier<CACHE> cacheSupplier) {
            super(recipeType, inputAExtractor, (IInputCache)cacheSupplier.get(), inputBExtractor, (IInputCache)cacheSupplier.get());
        }
    }
}

