/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@NothingNullByDefault
public class MekanismShapedRecipe
extends WrappedShapedRecipe {
    public MekanismShapedRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializersInternal.MEK_DATA.get();
    }

    @Override
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack resultItem = this.getResultItem(provider);
        if (resultItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack toReturn = resultItem.copy();
        ArrayList<ItemStack> componentInputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.isComponentsPatchEmpty()) continue;
            componentInputs.add(stack);
        }
        if (componentInputs.isEmpty()) {
            return toReturn;
        }
        Set<RecipeUpgradeType> supportedTypes = RecipeUpgradeData.getSupportedTypes(toReturn);
        if (supportedTypes.isEmpty()) {
            return toReturn;
        }
        EnumMap<RecipeUpgradeType, List> upgradeInfo = new EnumMap<RecipeUpgradeType, List>(RecipeUpgradeType.class);
        for (ItemStack itemStack : componentInputs) {
            Set<RecipeUpgradeType> stackSupportedTypes = RecipeUpgradeData.getSupportedTypes(itemStack);
            for (RecipeUpgradeType supportedType : stackSupportedTypes) {
                RecipeUpgradeData<?> data;
                if (!supportedTypes.contains((Object)supportedType) || (data = RecipeUpgradeData.getUpgradeData(supportedType, itemStack)) == null) continue;
                upgradeInfo.computeIfAbsent(supportedType, type -> new ArrayList()).add(data);
            }
        }
        for (Map.Entry entry : upgradeInfo.entrySet()) {
            Object data;
            List upgradeData = (List)entry.getValue();
            if (upgradeData.isEmpty() || (data = RecipeUpgradeData.mergeUpgradeData(upgradeData)) != null && data.applyToStack(provider, toReturn)) continue;
            return ItemStack.EMPTY;
        }
        return toReturn;
    }
}

