/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.registration.impl.MekanismDamageType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageType;

public class DamageTypeRegister {
    private final Map<ResourceLocation, MekanismDamageType> damageTypes = new HashMap<ResourceLocation, MekanismDamageType>();
    private final String modid;

    public DamageTypeRegister(String modid) {
        this.modid = modid;
    }

    public MekanismDamageType create(String name) {
        return this.create(name, 0.0f);
    }

    public MekanismDamageType create(String name, float exhaustion) {
        return this.create(name, exhaustion, DamageEffects.HURT);
    }

    public MekanismDamageType create(String name, float exhaustion, DamageEffects effects) {
        MekanismDamageType type = new MekanismDamageType((ResourceKey<DamageType>)ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)name)), exhaustion, effects);
        this.damageTypes.put(type.registryName(), type);
        return type;
    }

    public Collection<MekanismDamageType> damageTypes() {
        return Collections.unmodifiableCollection(this.damageTypes.values());
    }
}

