/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.util.EnumUtils;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum CableTier implements ITier
{
    BASIC(BaseTier.BASIC, 8000L),
    ADVANCED(BaseTier.ADVANCED, 128000L),
    ELITE(BaseTier.ELITE, 1024000L),
    ULTIMATE(BaseTier.ULTIMATE, 0x7D0000L);

    private final long baseCapacity;
    private final BaseTier baseTier;
    @Nullable
    private CachedLongValue capacityReference;

    private CableTier(BaseTier tier, long capacity) {
        this.baseCapacity = capacity;
        this.baseTier = tier;
    }

    public static CableTier get(BaseTier tier) {
        for (CableTier transmitter : EnumUtils.CABLE_TIERS) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public long getCableCapacity() {
        return this.capacityReference == null ? this.getBaseCapacity() : this.capacityReference.getOrDefault();
    }

    public long getBaseCapacity() {
        return this.baseCapacity;
    }

    public void setConfigReference(CachedLongValue capacityReference) {
        this.capacityReference = capacityReference;
    }
}

