/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world.height;

import mekanism.common.config.IConfigTranslation;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.resource.ore.OreAnchor;
import mekanism.common.world.height.AnchorType;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public record ConfigurableVerticalAnchor(CachedEnumValue<AnchorType> anchorType, CachedIntValue value) {
    public static ConfigurableVerticalAnchor create(IMekanismConfig config, ModConfigSpec.Builder builder, String path, IConfigTranslation translation, OreAnchor defaultAnchor, @Nullable ConfigurableVerticalAnchor minAnchor) {
        translation.applyToBuilder(builder).push(path);
        CachedEnumValue<AnchorType> type = CachedEnumValue.wrap(config, MekanismConfigTranslations.WORLD_ANCHOR_TYPE.applyToBuilder(builder).comment(new String[]{"Absolute (y = value)", "Above Bottom (y = minY + value)", "Below Top (y = depth - 1 + minY - value)"}).defineEnum("type", (Enum)defaultAnchor.type()));
        ModConfigSpec.ConfigValue value = minAnchor == null ? MekanismConfigTranslations.WORLD_ANCHOR_VALUE.applyToBuilder(builder).define("value", (Object)defaultAnchor.value()) : MekanismConfigTranslations.WORLD_ANCHOR_VALUE.applyToBuilder(builder).define("value", (Object)defaultAnchor.value(), o -> {
            if (o instanceof Integer) {
                Integer v = (Integer)o;
                return minAnchor.anchorType.getOrDefault() != type.getOrDefault() || v >= minAnchor.value.getOrDefault();
            }
            return false;
        });
        builder.pop();
        return new ConfigurableVerticalAnchor(type, CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)value));
    }

    public int resolveY(WorldGenerationContext context) {
        return ((AnchorType)this.anchorType.get()).resolveY(context, this.value.getAsInt());
    }

    @Override
    public String toString() {
        return switch ((AnchorType)this.anchorType.get()) {
            default -> throw new MatchException(null, null);
            case AnchorType.ABSOLUTE -> this.value.getAsInt() + " absolute";
            case AnchorType.ABOVE_BOTTOM -> this.value.getAsInt() + " above bottom";
            case AnchorType.BELOW_TOP -> this.value.getAsInt() + " below top";
        };
    }
}

