/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.neoforge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.lightoverlay.common.neoforge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.neoforge.LightOverlay;
import me.shedaniel.lightoverlay.common.neoforge.LightOverlayTicker;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class LightOverlayRenderer
implements Consumer<PoseStack> {
    private static final Function<Double, RenderType.CompositeRenderType> LINE = Util.memoize(double_ -> RenderType.create((String)"light_overlay_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(double_))).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(false)));
    private final Minecraft minecraft = Minecraft.getInstance();
    public Frustum frustum;
    public LightOverlayTicker ticker;

    public LightOverlayRenderer(LightOverlayTicker ticker) {
        this.ticker = ticker;
    }

    @Override
    public void accept(PoseStack poses) {
        if (LightOverlay.enabled) {
            LocalPlayer playerEntity = this.minecraft.player;
            BlockPos playerPos = new BlockPos(playerEntity.getBlockX(), playerEntity.getBlockY(), playerEntity.getBlockZ());
            int playerPosX = playerPos.getX() >> 4;
            int playerPosY = playerPos.getY() >> 5;
            int playerPosZ = playerPos.getZ() >> 4;
            CollisionContext collisionContext = CollisionContext.of((Entity)playerEntity);
            Camera camera = this.minecraft.gameRenderer.getMainCamera();
            int chunkRange = LightOverlay.getChunkRange();
            if (LightOverlay.showNumber) {
                this.renderLevels(poses, camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            } else {
                this.renderCrosses(poses, camera, playerPos, playerPosX, playerPosY, playerPosZ, chunkRange, collisionContext);
            }
            Minecraft.getInstance().renderBuffers().bufferSource().endLastBatch();
        }
    }

    private void renderLevels(PoseStack poses, Camera camera, BlockPos playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, CollisionContext collisionContext) {
        RenderSystem.depthMask((boolean)true);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos downMutable = new BlockPos.MutableBlockPos();
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (Mth.abs((int)(chunkPos.x - playerPosX)) > chunkRange || Mth.abs((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.abs((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                mutable.set(objectEntry.getLongKey());
                if (!mutable.closerThan((Vec3i)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.getX(), mutable.getY(), mutable.getZ(), mutable.getX() + 1, mutable.getX() + 1, mutable.getX() + 1)) continue;
                downMutable.set(mutable.getX(), mutable.getY() - 1, mutable.getZ());
                this.renderLevel(poses, source, camera, (Level)this.minecraft.level, (BlockPos)mutable, (BlockPos)downMutable, objectEntry.getByteValue(), collisionContext);
            }
        }
        RenderSystem.enableDepthTest();
    }

    public void renderLevel(PoseStack poses, MultiBufferSource.BufferSource source, Camera camera, Level world, BlockPos pos, BlockPos down, byte level, CollisionContext collisionContext) {
        String text = String.valueOf(level);
        Font font = this.minecraft.font;
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        VoxelShape upperOutlineShape = world.getBlockState(down).getShape((BlockGetter)world, down, collisionContext);
        if (!upperOutlineShape.isEmpty()) {
            cameraY += 1.0 - upperOutlineShape.max(Direction.Axis.Y);
        }
        double cameraZ = camera.getPosition().z;
        poses.pushPose();
        poses.translate((double)pos.getX() + 0.5 - cameraX, (double)pos.getY() - cameraY + 0.005, (double)pos.getZ() + 0.5 - cameraZ);
        poses.mulPose(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f));
        float size = 0.07f;
        poses.scale(-size, -size, size);
        float float_3 = (float)(-font.width(text)) / 2.0f + 0.4f;
        font.drawInBatch(text, float_3, -3.5f, level > LightOverlay.higherCrossLevel ? -16505852 : (LightOverlay.lowerCrossLevel >= 0 && level > LightOverlay.lowerCrossLevel ? -16750849 : -9236207), false, poses.last().pose(), (MultiBufferSource)source, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poses.popPose();
    }

    private void renderCrosses(PoseStack poses, Camera camera, BlockPos playerPos, int playerPosX, int playerPosY, int playerPosZ, int chunkRange, CollisionContext collisionContext) {
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer buffer = source.getBuffer((RenderType)LINE.apply(Double.valueOf(LightOverlay.lineWidth)));
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Map.Entry<CubicChunkPos, Long2ByteMap> entry : this.ticker.CHUNK_MAP.entrySet()) {
            CubicChunkPos chunkPos = entry.getKey();
            if (LightOverlay.caching && (Mth.abs((int)(chunkPos.x - playerPosX)) > chunkRange || Mth.abs((int)(chunkPos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.abs((int)(chunkPos.z - playerPosZ)) > chunkRange)) continue;
            for (Long2ByteMap.Entry objectEntry : entry.getValue().long2ByteEntrySet()) {
                byte crossType = objectEntry.getByteValue();
                mutable.set(objectEntry.getLongKey());
                if (!mutable.closerThan((Vec3i)playerPos, (double)LightOverlay.reach) || !this.isFrustumVisible(mutable.getX(), mutable.getY(), mutable.getZ(), mutable.getX() + 1, mutable.getX() + 1, mutable.getX() + 1)) continue;
                int color = switch (crossType) {
                    case 1 -> LightOverlay.redColor;
                    case 0 -> LightOverlay.yellowColor;
                    default -> LightOverlay.secondaryColor;
                };
                this.renderCross(poses.last().pose(), buffer, camera, (Level)this.minecraft.level, (BlockPos)mutable, color, collisionContext);
            }
        }
    }

    public void renderCross(Matrix4f pose, VertexConsumer builder, Camera camera, Level world, BlockPos pos, int color, CollisionContext collisionContext) {
        float cameraX = (float)camera.getPosition().x;
        float cameraY = (float)camera.getPosition().y - 0.005f;
        float blockOffset = 0.0f;
        VoxelShape upperOutlineShape = world.getBlockState(pos).getShape((BlockGetter)world, pos, collisionContext);
        if (!upperOutlineShape.isEmpty()) {
            blockOffset = (float)((double)blockOffset + upperOutlineShape.max(Direction.Axis.Y));
        }
        float cameraZ = (float)camera.getPosition().z;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float x = (float)pos.getX() - cameraX;
        float y = (float)pos.getY() - cameraY + blockOffset;
        float z = (float)pos.getZ() - cameraZ;
        builder.addVertex(pose, x + 0.01f, y, z + 0.01f).setColor(red, green, blue, 255);
        builder.addVertex(pose, x + 0.99f, y, z + 0.99f).setColor(red, green, blue, 255);
        builder.addVertex(pose, x + 0.99f, y, z + 0.01f).setColor(red, green, blue, 255);
        builder.addVertex(pose, x + 0.01f, y, z + 0.99f).setColor(red, green, blue, 255);
    }

    public boolean isFrustumVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.frustum.isVisible(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }
}

