/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.neoforge.mixin;

import me.shedaniel.lightoverlay.common.neoforge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.neoforge.LightOverlay;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public class MixinClientConnection {
    @Inject(method={"genericsFtw(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;)V"}, at={@At(value="HEAD")})
    private static void handlePacket(Packet packet, PacketListener listener, CallbackInfo ci) {
        try {
            if (!(listener instanceof ClientPacketListener)) {
                return;
            }
            ClientPacketListener packetListener = (ClientPacketListener)listener;
            ClientLevel level = packetListener.getLevel();
            if (level == null) {
                return;
            }
            if (packet instanceof ClientboundBlockUpdatePacket) {
                ClientboundBlockUpdatePacket p = (ClientboundBlockUpdatePacket)packet;
                LightOverlay.queueChunkAndNear(new CubicChunkPos(p.getPos()));
            } else if (packet instanceof ClientboundSetChunkCacheCenterPacket) {
                int start;
                ClientboundSetChunkCacheCenterPacket p = (ClientboundSetChunkCacheCenterPacket)packet;
                int height = Mth.ceil((double)((double)level.getHeight() / 32.0));
                for (int y = start = Math.floorDiv(level.getMinBuildHeight(), 32); y < start + height; ++y) {
                    LightOverlay.queueChunkAndNear(new CubicChunkPos(p.getX(), y, p.getZ()));
                }
            } else if (packet instanceof ClientboundSectionBlocksUpdatePacket) {
                ClientboundSectionBlocksUpdatePacket p = (ClientboundSectionBlocksUpdatePacket)packet;
                LightOverlay.queueChunkAndNear(new CubicChunkPos(p.sectionPos.getX(), p.sectionPos.getY() >> 1, p.sectionPos.getZ()));
            } else if (packet instanceof ClientboundLightUpdatePacket) {
                int start;
                ClientboundLightUpdatePacket p = (ClientboundLightUpdatePacket)packet;
                int height = Mth.ceil((double)((double)level.getHeight() / 32.0));
                for (int y = start = Math.floorDiv(level.getMinBuildHeight(), 32); y < start + height; ++y) {
                    LightOverlay.queueChunk(new CubicChunkPos(p.getX(), y, p.getZ()));
                }
            }
        }
        catch (Throwable throwable) {
            new RuntimeException("Light Overlay failed to process packet", throwable).printStackTrace();
        }
    }
}

