/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class FairyFamiliarModel
extends EntityModel<FairyFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart head;
    public ModelPart tail1;
    public ModelPart leftArm;
    public ModelPart leftLeg1;
    public ModelPart leftWing;
    public ModelPart rightLeg1;
    public ModelPart rightArm;
    public ModelPart rightWing;
    public ModelPart nose;
    public ModelPart leftHorn1;
    public ModelPart leftEar1;
    public ModelPart leftEye;
    public ModelPart rightEye;
    public ModelPart rightEar1;
    public ModelPart rightHorn1;
    public ModelPart whisker1;
    public ModelPart whisker2;
    public ModelPart whisker3;
    public ModelPart whisker4;
    public ModelPart tooth1;
    public ModelPart tooth2;
    public ModelPart tooth3;
    public ModelPart leftHorn2;
    public ModelPart flower;
    public ModelPart leftEar2;
    public ModelPart rightEar2;
    public ModelPart rightHorn2;
    public ModelPart tail2;
    public ModelPart tail3;
    public ModelPart leftWand;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;
    public ModelPart rightWand;

    public FairyFamiliarModel(ModelPart part) {
        super(RenderType::entityTranslucent);
        this.body = part.getChild("body");
        this.head = this.body.getChild("head");
        this.tail1 = this.body.getChild("tail1");
        this.leftArm = this.body.getChild("leftArm");
        this.leftLeg1 = this.body.getChild("leftLeg1");
        this.leftWing = this.body.getChild("leftWing");
        this.rightLeg1 = this.body.getChild("rightLeg1");
        this.rightArm = this.body.getChild("rightArm");
        this.rightWing = this.body.getChild("rightWing");
        this.nose = this.head.getChild("nose");
        this.leftHorn1 = this.head.getChild("leftHorn1");
        this.leftEar1 = this.head.getChild("leftEar1");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.rightEar1 = this.head.getChild("rightEar1");
        this.rightHorn1 = this.head.getChild("rightHorn1");
        this.whisker1 = this.nose.getChild("whisker1");
        this.whisker2 = this.nose.getChild("whisker2");
        this.whisker3 = this.nose.getChild("whisker3");
        this.whisker4 = this.nose.getChild("whisker4");
        this.tooth1 = this.nose.getChild("tooth1");
        this.tooth2 = this.nose.getChild("tooth2");
        this.tooth3 = this.nose.getChild("tooth3");
        this.leftHorn2 = this.leftHorn1.getChild("leftHorn2");
        this.flower = this.leftHorn1.getChild("flower");
        this.leftEar2 = this.leftEar1.getChild("leftEar2");
        this.rightEar2 = this.rightEar1.getChild("rightEar2");
        this.rightHorn2 = this.rightHorn1.getChild("rightHorn2");
        this.tail2 = this.tail1.getChild("tail2");
        this.tail3 = this.tail2.getChild("tail3");
        this.leftWand = this.leftArm.getChild("leftWand");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.leftLeg3 = this.leftLeg1.getChild("leftLeg3");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.rightLeg3 = this.rightLeg1.getChild("rightLeg3");
        this.rightWand = this.rightArm.getChild("rightWand");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -6.0f, -1.5f, 5.0f, 6.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 0).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = body.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(45, 4).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.50823987f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(53, 8).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg1 = body.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.2f, (float)-0.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, -5.5f, 0.0f, 10.0f, 11.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)1.0f, (float)0.0f, (float)-0.5864306f, (float)0.0f));
        PartDefinition rightLeg1 = body.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.2f, (float)-0.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(53, 8).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(0, 21).addBox(-10.0f, -5.5f, 0.0f, 10.0f, 11.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)1.0f, (float)0.0f, (float)0.5864306f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(36, 0).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn1 = head.addOrReplaceChild("leftHorn1", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.2f, (float)-4.5f, (float)1.0f, (float)-0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar1 = head.addOrReplaceChild("leftEar1", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)2.1f, (float)-3.4f, (float)1.9f, (float)0.312763f, (float)-0.27366763f, (float)-0.43004912f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(54, 0).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-3.0f, (float)-0.7f, (float)0.312763f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(54, 0).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.5f, (float)-3.0f, (float)-0.7f, (float)0.312763f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar1 = head.addOrReplaceChild("rightEar1", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, true), PartPose.offsetAndRotation((float)-2.1f, (float)-3.4f, (float)1.9f, (float)0.312763f, (float)0.27366763f, (float)0.43004912f));
        PartDefinition rightHorn1 = head.addOrReplaceChild("rightHorn1", CubeListBuilder.create().texOffs(48, 0).addBox(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.2f, (float)-4.5f, (float)1.0f, (float)-0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition whisker1 = nose.addOrReplaceChild("whisker1", CubeListBuilder.create().texOffs(0, 17).addBox(0.0f, -0.5f, 0.0f, 3.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)0.4f, (float)-1.0f, (float)0.0f, (float)0.312763f, (float)0.39095375f));
        PartDefinition whisker2 = nose.addOrReplaceChild("whisker2", CubeListBuilder.create().texOffs(0, 17).addBox(0.0f, -0.5f, 0.0f, 3.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)-0.4f, (float)-2.0f, (float)0.039095376f, (float)0.39095375f, (float)-0.27366763f));
        PartDefinition whisker3 = nose.addOrReplaceChild("whisker3", CubeListBuilder.create().texOffs(0, 17).addBox(-3.0f, -0.5f, 0.0f, 3.0f, 2.0f, 0.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)-0.4f, (float)-2.0f, (float)0.039095376f, (float)-0.39095375f, (float)0.27366763f));
        PartDefinition whisker4 = nose.addOrReplaceChild("whisker4", CubeListBuilder.create().texOffs(0, 17).addBox(-3.0f, -0.5f, 0.0f, 3.0f, 2.0f, 0.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)0.4f, (float)-1.0f, (float)0.0f, (float)-0.312763f, (float)-0.39095375f));
        PartDefinition tooth1 = nose.addOrReplaceChild("tooth1", CubeListBuilder.create().texOffs(31, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.4f, (float)0.4f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth2 = nose.addOrReplaceChild("tooth2", CubeListBuilder.create().texOffs(31, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.4f, (float)0.5f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth3 = nose.addOrReplaceChild("tooth3", CubeListBuilder.create().texOffs(31, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.7f, (float)0.6f, (float)-2.9f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn2 = leftHorn1.addOrReplaceChild("leftHorn2", CubeListBuilder.create().texOffs(13, 0).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)-1.5f, (float)0.0f, (float)-0.35185838f, (float)0.0f, (float)0.0f));
        PartDefinition flower = leftHorn1.addOrReplaceChild("flower", CubeListBuilder.create().texOffs(25, 7).addBox(0.0f, -1.5f, -1.5f, 0.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.52f, (float)-1.0f, (float)0.0f, (float)0.7824311f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar2 = leftEar1.addOrReplaceChild("leftEar2", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1111503f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar2 = rightEar1.addOrReplaceChild("rightEar2", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1111503f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn2 = rightHorn1.addOrReplaceChild("rightHorn2", CubeListBuilder.create().texOffs(13, 0).addBox(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)-1.5f, (float)0.0f, (float)-0.35185838f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(36, 6).addBox(-1.0f, -0.5f, 0.0f, 2.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)0.0f, (float)2.5f, (float)0.27366763f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(55, 4).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.5f, (float)0.27366763f, (float)0.0f, (float)0.0f));
        PartDefinition leftWand = leftArm.addOrReplaceChild("leftWand", CubeListBuilder.create().texOffs(8, 9).addBox(-0.5f, -0.5f, -5.0f, 1.0f, 1.0f, 5.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)4.0f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(17, 0).addBox(0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.3f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition leftLeg3 = leftLeg1.addOrReplaceChild("leftLeg3", CubeListBuilder.create().texOffs(17, 0).addBox(0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.3f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(17, 0).addBox(0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)-0.3f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition rightLeg3 = rightLeg1.addOrReplaceChild("rightLeg3", CubeListBuilder.create().texOffs(17, 0).addBox(0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.3f, (float)4.01f, (float)-0.3f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition rightWand = rightArm.addOrReplaceChild("rightWand", CubeListBuilder.create().texOffs(8, 9).addBox(-0.5f, -0.5f, -5.0f, 1.0f, 1.0f, 5.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(FairyFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        float bodyRot;
        this.showModels(pEntity);
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        ModelPart mainArm = this.getMainArm(pEntity);
        this.leftArm.yRot = 0.0f;
        this.rightArm.yRot = 0.0f;
        this.leftWand.xRot = 0.0f;
        this.rightWand.xRot = 0.0f;
        this.head.xRot = 0.0f;
        this.head.yRot = this.toRads(netHeadYaw) * 0.8f;
        this.head.zRot = this.toRads(headPitch) * 0.8f;
        float animationHeight = pEntity.getWingRot(partialTicks);
        this.leftWing.yRot = animationHeight * this.toRads(15.0f) - 0.59f;
        this.rightWing.yRot = -animationHeight * this.toRads(15.0f) + 0.59f;
        this.body.xRot = bodyRot = limbSwingAmount * this.toRads(100.0f);
        this.leftArm.xRot = -bodyRot * 3.0f + Mth.cos((float)(pAgeInTicks * 0.2f)) * this.toRads(10.0f);
        this.rightArm.xRot = -bodyRot * 3.0f + Mth.cos((float)(pAgeInTicks * 0.2f + (float)Math.PI)) * this.toRads(10.0f);
        this.leftLeg1.xRot = this.body.xRot;
        this.rightLeg1.xRot = this.body.xRot;
        this.tail1.xRot = -0.51f + Mth.cos((float)(pAgeInTicks * 0.2f)) * this.toRads(10.0f);
        this.tail2.xRot = 0.27f + Mth.cos((float)(pAgeInTicks * 0.2f)) * this.toRads(10.0f);
        this.tail3.xRot = 0.27f + Mth.cos((float)(pAgeInTicks * 0.2f)) * this.toRads(10.0f);
        if (pEntity.hasMagicTarget()) {
            this.body.xRot = this.toRads(20.0f);
            this.setRotateAngle(this.head, 0.0f, 0.0f, 0.0f);
            this.leftArm.xRot = this.toRads(-80.0f) + Mth.cos((float)(pAgeInTicks * 0.2f)) * this.toRads(20.0f);
            this.rightArm.xRot = this.toRads(-80.0f) + Mth.cos((float)(pAgeInTicks * 0.2f)) * this.toRads(20.0f);
            this.leftLeg1.xRot = this.toRads(20.0f);
            this.rightLeg1.xRot = this.toRads(20.0f);
        } else if (pEntity.isPartying()) {
            this.body.xRot = 0.0f;
            mainArm.xRot = pEntity.getPartyArmRotX(partialTicks);
            mainArm.yRot = pEntity.getPartyArmRotY(partialTicks);
        } else if (pEntity.isSitting()) {
            this.body.xRot = this.toRads(90.0f);
            this.head.xRot = this.toRads(-10.0f);
            this.head.yRot = 0.0f;
            this.head.zRot = 0.0f;
            this.leftArm.xRot = this.toRads(-80.0f) + Mth.cos((float)(pAgeInTicks * 0.1f)) * this.toRads(10.0f);
            this.rightArm.xRot = this.toRads(-80.0f) + Mth.cos((float)(pAgeInTicks * 0.1f + (float)Math.PI)) * this.toRads(10.0f);
            this.leftWand.xRot = this.toRads(60.0f);
            this.rightWand.xRot = this.toRads(60.0f);
            this.leftLeg1.xRot = this.toRads(-80.0f) + Mth.cos((float)(pAgeInTicks * 0.1f + (float)Math.PI)) * this.toRads(10.0f);
            this.rightLeg1.xRot = this.toRads(-80.0f) + Mth.cos((float)(pAgeInTicks * 0.1f)) * this.toRads(10.0f);
            this.tail1.xRot = this.toRads(-130.0f) + Mth.cos((float)(pAgeInTicks * 0.1f)) * this.toRads(5.0f);
            this.tail2.xRot = this.toRads(-15.0f) + Mth.cos((float)(pAgeInTicks * 0.05f)) * this.toRads(5.0f);
            this.tail3.xRot = this.toRads(-15.0f) + Mth.cos((float)(pAgeInTicks * 0.05f)) * this.toRads(5.0f);
        }
        float supportAnim = pEntity.getSupportAnim(partialTicks);
        if (supportAnim != 0.0f) {
            mainArm.xRot = this.toRads(-80.0f) + Mth.sin((float)(supportAnim * (float)Math.PI * 3.0f)) * this.toRads(35.0f);
            mainArm.yRot = Mth.cos((float)(supportAnim * (float)Math.PI * 3.0f)) * this.toRads(35.0f);
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private ModelPart getMainArm(FairyFamiliarEntity pEntity) {
        return pEntity.isLeftHanded() ? this.leftArm : this.rightArm;
    }

    private void showModels(FairyFamiliarEntity entityIn) {
        boolean hasTeeth = entityIn.hasTeeth();
        boolean isLeftHanded = entityIn.isLeftHanded();
        this.flower.visible = entityIn.hasFlower();
        this.tooth1.visible = hasTeeth;
        this.tooth2.visible = hasTeeth;
        this.tooth3.visible = hasTeeth;
        this.whisker1.visible = !hasTeeth;
        this.whisker2.visible = !hasTeeth;
        this.whisker3.visible = !hasTeeth;
        this.whisker4.visible = !hasTeeth;
        this.leftWand.visible = isLeftHanded;
        this.rightWand.visible = !isLeftHanded;
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

