/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChalkGlyphBlock
extends Block {
    public static final IntegerProperty SIGN = IntegerProperty.create((String)"sign", (int)0, (int)12);
    public static final int MAX_SIGN = 12;
    private static final VoxelShape SHAPE = Block.box((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)0.04, (double)14.5);
    protected Supplier<Item> chalk;
    protected Supplier<Integer> color;

    public ChalkGlyphBlock(BlockBehaviour.Properties properties, Supplier<Integer> color, Supplier<Item> chalk) {
        super(properties);
        this.color = color;
        this.chalk = chalk;
    }

    public int getColor() {
        return this.color.get();
    }

    public Item getChalk() {
        return this.chalk.get();
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)worldIn, pos)) {
            worldIn.removeBlock(pos, false);
        }
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return true;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos down = pos.below();
        BlockState downState = worldIn.getBlockState(down);
        return downState.isFaceSturdy((BlockGetter)worldIn, down, Direction.UP) && state.canBeReplaced();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        int sign = context.getLevel().getRandom().nextInt(13);
        BlockState current = context.getLevel().getBlockState(pos);
        if (current.getBlock() == this) {
            sign = ((Integer)current.getValue((Property)SIGN) + 1) % 13;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SIGN, (Comparable)Integer.valueOf(sign))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SIGN, BlockStateProperties.HORIZONTAL_FACING});
        super.createBlockStateDefinition(builder);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        if (BuiltInRegistries.ITEM.containsValue((Object)this.getChalk())) {
            return new ItemStack((ItemLike)this.getChalk());
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.OPEN;
    }
}

