/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class RainbowGlyphBlock
extends ChalkGlyphBlock {
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)15);
    public static final BooleanProperty CYCLE = BooleanProperty.create((String)"cycle");
    protected Supplier<Item> chalk;
    protected Supplier<Integer> color;
    protected Boolean cycle;

    public RainbowGlyphBlock(BlockBehaviour.Properties properties, Boolean cycle, Supplier<Item> chalk) {
        super(properties, (Supplier<Integer>)Occultism.CLIENT_CONFIG.visuals.whiteChalkGlyphColor, chalk);
        this.chalk = chalk;
        this.cycle = cycle;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CYCLE, (Comparable)cycle));
    }

    public int getColor(BlockState state) {
        return switch ((Integer)state.getValue((Property)COLOR)) {
            case 1 -> (Integer)Occultism.CLIENT_CONFIG.visuals.lightGrayChalkGlyphColor.get();
            case 2 -> (Integer)Occultism.CLIENT_CONFIG.visuals.grayChalkGlyphColor.get();
            case 3 -> (Integer)Occultism.CLIENT_CONFIG.visuals.blackChalkGlyphColor.get();
            case 4 -> (Integer)Occultism.CLIENT_CONFIG.visuals.redChalkGlyphColor.get();
            case 5 -> (Integer)Occultism.CLIENT_CONFIG.visuals.brownChalkGlyphColor.get();
            case 6 -> (Integer)Occultism.CLIENT_CONFIG.visuals.orangeChalkGlyphColor.get();
            case 7 -> (Integer)Occultism.CLIENT_CONFIG.visuals.yellowChalkGlyphColor.get();
            case 8 -> (Integer)Occultism.CLIENT_CONFIG.visuals.limeChalkGlyphColor.get();
            case 9 -> (Integer)Occultism.CLIENT_CONFIG.visuals.greenChalkGlyphColor.get();
            case 10 -> (Integer)Occultism.CLIENT_CONFIG.visuals.cyanChalkGlyphColor.get();
            case 11 -> (Integer)Occultism.CLIENT_CONFIG.visuals.blueChalkGlyphColor.get();
            case 12 -> (Integer)Occultism.CLIENT_CONFIG.visuals.lightBlueChalkGlyphColor.get();
            case 13 -> (Integer)Occultism.CLIENT_CONFIG.visuals.pinkChalkGlyphColor.get();
            case 14 -> (Integer)Occultism.CLIENT_CONFIG.visuals.magentaChalkGlyphColor.get();
            case 15 -> (Integer)Occultism.CLIENT_CONFIG.visuals.purpleChalkGlyphColor.get();
            default -> (Integer)Occultism.CLIENT_CONFIG.visuals.whiteChalkGlyphColor.get();
        };
    }

    @Override
    public Item getChalk() {
        return this.chalk.get();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        int sign = context.getLevel().getRandom().nextInt(13);
        int cor = 0;
        boolean cc = this.cycle;
        BlockState current = context.getLevel().getBlockState(pos);
        if (this.getChalk().asItem().equals(OccultismItems.CHALK_RAINBOW.get())) {
            cor = 4;
        }
        if (current.getBlock() == this) {
            sign = ((Integer)current.getValue((Property)SIGN) + 1) % 13;
            cor = (Integer)current.getValue((Property)COLOR);
            cc = (Boolean)current.getValue((Property)CYCLE);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(cor))).setValue((Property)CYCLE, (Comparable)Boolean.valueOf(cc))).setValue((Property)SIGN, (Comparable)Integer.valueOf(sign))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, CYCLE});
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild) {
            if (stack.getItem().equals(OccultismItems.SPIRIT_ATTUNED_GEM.get())) {
                if (((Boolean)state.getValue((Property)CYCLE)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CYCLE, (Comparable)Boolean.valueOf(false)));
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CYCLE, (Comparable)Boolean.valueOf(true)));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_RED)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(4)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_BROWN)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(5)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_ORANGE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(6)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_YELLOW)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(7)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_LIME)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(8)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_GREEN)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(9)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_CYAN)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(10)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_BLUE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(11)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_LIGHT_BLUE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(12)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_PINK)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(13)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_MAGENTA)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(14)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_PURPLE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(15)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (state.getBlock().equals(OccultismBlocks.CHALK_GLYPH_VOID.get())) {
                if (stack.getTags().toList().contains(Tags.Items.DYES_WHITE)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(0)));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (stack.getTags().toList().contains(Tags.Items.DYES_LIGHT_GRAY)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(1)));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (stack.getTags().toList().contains(Tags.Items.DYES_GRAY)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(2)));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (stack.getTags().toList().contains(Tags.Items.DYES_BLACK)) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(3)));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void animateTick(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)state.getValue((Property)CYCLE)).booleanValue()) {
            int nextColor = (Integer)state.getValue((Property)COLOR) + 1;
            if (nextColor == 16 && state.getBlock().equals(OccultismBlocks.CHALK_GLYPH_VOID.get())) {
                nextColor = 0;
            }
            if (nextColor == 16 && state.getBlock().equals(OccultismBlocks.CHALK_GLYPH_RAINBOW.get())) {
                nextColor = 4;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(nextColor)));
        }
    }
}

