/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.misc.DepositOrder;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ManageMachineGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;
    protected BlockEntity cachedStorageAccessor;
    protected DepositOrder cachedStorageAccessorOrder;
    protected ManageMachineJob job;

    public ManageMachineGoal(SpiritEntity entity, ManageMachineJob job) {
        this.entity = entity;
        this.job = job;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.position(), Math3DUtil.center(this.targetBlock));
        return this.targetBlock.relative(Direction.fromYRot((double)angle).getOpposite());
    }

    public boolean canUse() {
        if (this.entity.getTarget() != null) {
            return false;
        }
        if (!this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean canContinueToUse() {
        return this.targetBlock != null && this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.resetTarget();
    }

    public void tick() {
        if (this.targetBlock != null) {
            if (this.entity.level().getBlockEntity(this.targetBlock) != null && this.job.getStorageController() != null) {
                float accessDistance;
                BlockEntity blockEntity = this.entity.level().getBlockEntity(this.targetBlock);
                double distance = this.entity.position().distanceTo(Math3DUtil.center(this.targetBlock));
                if (distance < (double)(accessDistance = 2.2f)) {
                    this.entity.getNavigation().stop();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(moveTarget, 0), 1.0);
                }
                if (distance < (double)accessDistance && this.canSeeTarget()) {
                    IItemHandler machineHandler;
                    DepositOrder currentOrder = this.job.getCurrentDepositOrder();
                    MachineReference machineReference = this.job.getManagedMachine();
                    if (blockEntity instanceof IStorageControllerProxy && currentOrder != null) {
                        ItemStack itemToExtract = this.job.getStorageController().getItemStack(currentOrder.comparator, currentOrder.amount, true);
                        IItemHandler handler = (IItemHandler)this.entity.getCapability(Capabilities.ItemHandler.ENTITY);
                        if (!itemToExtract.isEmpty() && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemToExtract, (boolean)true).isEmpty()) {
                            ItemStack extracted = this.job.getStorageController().getItemStack(currentOrder.comparator, currentOrder.amount, false);
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
                            this.entity.setDepositPosition(machineReference.insertGlobalPos.getPos());
                            this.entity.setDepositFacing(machineReference.insertFacing);
                            this.job.setCurrentDepositOrder(null);
                            this.targetBlock = null;
                        }
                    } else if (this.targetBlock.equals((Object)machineReference.extractGlobalPos.getPos()) && (machineHandler = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)machineReference.extractFacing)) != null) {
                        IItemHandler entityHandler = (IItemHandler)this.entity.getCapability(Capabilities.ItemHandler.ENTITY);
                        boolean movedAnyItems = false;
                        for (int i = 0; i < machineHandler.getSlots(); ++i) {
                            ItemStack itemToExtract = machineHandler.extractItem(i, machineHandler.getSlotLimit(i), true);
                            ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)itemToExtract, (boolean)true);
                            if (itemToExtract.isEmpty() || remaining.getCount() == itemToExtract.getCount()) continue;
                            ItemStack extracted = machineHandler.extractItem(i, itemToExtract.getCount() - remaining.getCount(), false);
                            ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)extracted, (boolean)false);
                            movedAnyItems = true;
                            if (remaining.getCount() > 0) break;
                        }
                        if (movedAnyItems) {
                            BlockEntity storageControllerProxy = this.findClosestStorageProxy();
                            if (storageControllerProxy != null) {
                                this.entity.setDepositPosition(storageControllerProxy.getBlockPos());
                            }
                            this.entity.setDepositFacing(Direction.UP);
                            this.targetBlock = null;
                        }
                    }
                    this.stop();
                }
            } else {
                this.stop();
            }
        }
    }

    public boolean canSeeTarget() {
        return true;
    }

    protected BlockEntity findClosestStorageProxy() {
        if (this.cachedStorageAccessor != null && this.cachedStorageAccessorOrder == this.job.getCurrentDepositOrder()) {
            return this.cachedStorageAccessor;
        }
        Level level = this.entity.level();
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos machinePosition = this.job.getManagedMachine().insertGlobalPos.getPos();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        Stream searchBlocks = BlockPos.betweenClosedStream((BlockPos)machinePosition.offset(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)machinePosition.offset(workAreaSize, workAreaSize / 2, workAreaSize));
        searchBlocks.forEachOrdered(pos -> {
            IStorageControllerProxy proxy;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IStorageControllerProxy && (proxy = (IStorageControllerProxy)blockEntity).getLinkedStorageControllerPosition() != null && proxy.getLinkedStorageControllerPosition().equals(this.job.getStorageControllerPosition())) {
                allBlocks.add(pos.immutable());
            }
        });
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.cachedStorageAccessor = level.getBlockEntity((BlockPos)allBlocks.get(0));
            this.cachedStorageAccessorOrder = this.job.getCurrentDepositOrder();
            return this.cachedStorageAccessor;
        }
        return null;
    }

    private boolean startTargetingStorageController(DepositOrder depositOrder, MachineReference machineReference, BlockEntity machine, IStorageController storageController) {
        IItemHandler machineItemHandler = (IItemHandler)machine.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, machine.getBlockPos(), machine.getBlockState(), machine, (Object)machineReference.insertFacing);
        if (machineItemHandler == null) {
            return false;
        }
        ItemStack orderStack = storageController.getItemStack(depositOrder.comparator, depositOrder.amount, true);
        if (!orderStack.isEmpty() && ItemHandlerHelper.insertItem((IItemHandler)machineItemHandler, (ItemStack)orderStack, (boolean)true).isEmpty()) {
            BlockEntity storageControllerProxy = this.findClosestStorageProxy();
            if (storageControllerProxy != null) {
                this.targetBlock = storageControllerProxy.getBlockPos();
                return true;
            }
            this.targetBlock = null;
            return true;
        }
        if (!orderStack.isEmpty()) {
            return false;
        }
        return false;
    }

    private boolean startTargetingExtractBlockEntity(DepositOrder depositOrder, MachineReference machineReference, BlockEntity extractBlockEntity, IStorageController storageController) {
        IItemHandler machineItemHandler = (IItemHandler)extractBlockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, extractBlockEntity.getBlockPos(), extractBlockEntity.getBlockState(), extractBlockEntity, (Object)machineReference.extractFacing);
        if (machineItemHandler == null) {
            return false;
        }
        for (int i = 0; i < machineItemHandler.getSlots(); ++i) {
            if (machineItemHandler.getStackInSlot(i).isEmpty()) continue;
            this.targetBlock = extractBlockEntity.getBlockPos();
            return true;
        }
        this.targetBlock = null;
        return false;
    }

    private void resetTarget() {
        DepositOrder currentOrder = this.job.getCurrentDepositOrder();
        MachineReference machineReference = this.job.getManagedMachine();
        BlockEntity machine = this.job.getManagedMachineBlockEntity();
        BlockEntity extractBlockEntity = this.job.getExtractBlockEntity();
        IStorageController storageController = this.job.getStorageController();
        if (machine != null && extractBlockEntity != null && storageController != null) {
            if (machine.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, machine.getBlockPos(), machine.getBlockState(), machine, (Object)machineReference.insertFacing) == null || extractBlockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, extractBlockEntity.getBlockPos(), extractBlockEntity.getBlockState(), extractBlockEntity, (Object)machineReference.extractFacing) == null) {
                this.job.setManagedMachine(null);
                this.targetBlock = null;
                return;
            }
            if (currentOrder == null || !this.startTargetingStorageController(currentOrder, machineReference, machine, storageController)) {
                this.startTargetingExtractBlockEntity(currentOrder, machineReference, extractBlockEntity, storageController);
            }
        }
    }
}

