/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.crafting.recipe.CrystallizeRecipe;
import com.klikli_dev.occultism.crafting.recipe.TieredSingleRecipeInput;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityEvent;

public class CrystallizerJob
extends SpiritJob {
    public static final String DROPPED_BY_CRYSTALLIZER = "occultism:dropped_by_crystallizer";
    protected int crystallizeTimer;
    protected Supplier<Float> crystallizeTimeMultiplier;
    protected Supplier<Float> outputMultiplier;
    protected Supplier<Integer> tier;
    protected Optional<RecipeHolder<CrystallizeRecipe>> currentRecipe = Optional.empty();
    protected PickupItemsGoal pickupItemsGoal;
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public CrystallizerJob(SpiritEntity entity, Supplier<Float> crystallizeTimeMultiplier, Supplier<Float> outputMultiplier, Supplier<Integer> tier) {
        super(entity);
        this.crystallizeTimeMultiplier = crystallizeTimeMultiplier;
        this.outputMultiplier = outputMultiplier;
        this.tier = tier;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.targetSelector.addGoal(1, (Goal)this.pickupItemsGoal);
        this.itemsToPickUp = this.entity.level().getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.CRYSTALLIZE_TYPE.get()).stream().filter(recipe -> {
            int minTier = ((CrystallizeRecipe)recipe.value()).getMinTier();
            int maxTier = ((CrystallizeRecipe)recipe.value()).getMaxTier();
            int currentTier = this.tier.get();
            return !(minTier >= 0 && minTier > currentTier || maxTier >= 0 && maxTier < currentTier);
        }).flatMap(recipe -> ((CrystallizeRecipe)recipe.value()).getIngredients().stream()).collect(Collectors.toList());
    }

    @Override
    public void cleanup() {
        this.entity.targetSelector.removeGoal((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.getItemInHand(InteractionHand.MAIN_HAND);
        TieredSingleRecipeInput recipeInput = new TieredSingleRecipeInput(handHeld, this.tier.get());
        if (!this.currentRecipe.isPresent() && !handHeld.isEmpty()) {
            this.currentRecipe = this.entity.level().getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.CRYSTALLIZE_TYPE.get(), (RecipeInput)recipeInput, this.entity.level());
            this.crystallizeTimer = 0;
            if (this.currentRecipe.isPresent()) {
                this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.AMETHYST_CLUSTER_STEP, SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
            } else {
                this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                ItemEntity droppedItem = this.entity.spawnAtLocation(handHeld);
                if (droppedItem != null) {
                    droppedItem.addTag(DROPPED_BY_CRYSTALLIZER);
                }
            }
        }
        if (this.currentRecipe.isPresent()) {
            if (handHeld.isEmpty() || !((CrystallizeRecipe)this.currentRecipe.get().value()).matches(recipeInput, this.entity.level())) {
                this.currentRecipe = Optional.empty();
            } else {
                ++this.crystallizeTimer;
                if (this.entity.level().getGameTime() % 10L == 0L) {
                    Vec3 pos = this.entity.position();
                    ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.WITCH, pos.x + this.entity.level().random.nextGaussian() / 3.0, pos.y + 0.5, pos.z + this.entity.level().random.nextGaussian() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.crystallizeTimer % 40 == 0) {
                    this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.AMETHYST_CLUSTER_STEP, SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.getRandom().nextFloat());
                }
                if ((float)this.crystallizeTimer >= (float)((CrystallizeRecipe)this.currentRecipe.get().value()).getCrystallizeTime() * this.crystallizeTimeMultiplier.get().floatValue()) {
                    ItemEntity droppedItem;
                    this.crystallizeTimer = 0;
                    ItemStack result = ((CrystallizeRecipe)this.currentRecipe.get().value()).assemble(recipeInput, (HolderLookup.Provider)this.entity.level().registryAccess());
                    float outputMultiplier = this.outputMultiplier.get().floatValue();
                    if (((CrystallizeRecipe)this.currentRecipe.get().value()).getIgnoreCrystallizeMultiplier()) {
                        outputMultiplier = 1.0f;
                    }
                    result.setCount((int)((float)result.getCount() * outputMultiplier));
                    ItemStack inputCopy = handHeld.copy();
                    inputCopy.setCount(1);
                    handHeld.shrink(1);
                    this.onCrystallize(inputCopy, result);
                    CrystallizerJobEvent event = new CrystallizerJobEvent((Entity)this.entity, inputCopy, result);
                    NeoForge.EVENT_BUS.post((Event)event);
                    if (!event.getResult().isEmpty() && (droppedItem = this.entity.spawnAtLocation(event.getResult())) != null) {
                        droppedItem.addTag(DROPPED_BY_CRYSTALLIZER);
                    }
                }
            }
        }
        super.update();
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("conversionTimer", this.crystallizeTimer);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.crystallizeTimer = compound.getInt("conversionTimer");
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        if (entity.getTags().contains(DROPPED_BY_CRYSTALLIZER) && entity.getAge() < (Integer)Occultism.SERVER_CONFIG.spiritJobs.crystallizerResultPickupDelay.get()) {
            return false;
        }
        ItemStack stack = entity.getItem();
        return !stack.isEmpty() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    public void onCrystallize(ItemStack input, ItemStack output) {
    }

    public static class CrystallizerJobEvent
    extends EntityEvent {
        private ItemStack input;
        private ItemStack result;

        public CrystallizerJobEvent(Entity entity, ItemStack input, ItemStack result) {
            super(entity);
            this.input = input;
            this.result = result;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public void setInput(ItemStack input) {
            this.input = input;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }
    }
}

