/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.klikli_dev.occultism.network.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MessageUpdateStacks
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"update_stacks");
    public static final CustomPacketPayload.Type<MessageUpdateStacks> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageUpdateStacks> STREAM_CODEC = CustomPacketPayload.codec(MessageUpdateStacks::encode, MessageUpdateStacks::new);
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private List<ItemStack> stacks;
    private int maxItemTypes;
    private int usedItemTypes;
    private long maxTotalItemCount;
    private long usedTotalItemCount;
    private ByteBuf payload;

    public MessageUpdateStacks(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageUpdateStacks(List<ItemStack> stacks, int maxItemTypes, int usedItemTypes, long maxTotalItemCount, long usedTotalItemCount, RegistryAccess registryAccess) {
        this.stacks = stacks;
        this.maxItemTypes = maxItemTypes;
        this.usedItemTypes = usedItemTypes;
        this.maxTotalItemCount = maxTotalItemCount;
        this.usedTotalItemCount = usedTotalItemCount;
        this.compress(registryAccess);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        IStorageControllerGui gui;
        this.uncompress(player.registryAccess());
        Screen screen = minecraft.screen;
        if (screen instanceof IStorageControllerGui && (gui = (IStorageControllerGui)screen) != null) {
            gui.setStacks(this.stacks);
            gui.setUsedStorageSize(this.usedItemTypes, this.usedTotalItemCount);
            gui.setMaxStorageSize(this.maxItemTypes, this.maxTotalItemCount);
            gui.markDirty();
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.usedItemTypes);
        buf.writeVarLong(this.usedTotalItemCount);
        buf.writeVarInt(this.maxItemTypes);
        buf.writeVarLong(this.maxTotalItemCount);
        buf.writeVarInt(this.payload.readableBytes());
        buf.writeBytes(this.payload, 0, this.payload.readableBytes());
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.usedItemTypes = buf.readVarInt();
        this.usedTotalItemCount = buf.readVarLong();
        this.maxItemTypes = buf.readVarInt();
        this.maxTotalItemCount = buf.readVarLong();
        int compressedSize = buf.readVarInt();
        this.payload = Unpooled.buffer((int)compressedSize);
        buf.readBytes(this.payload, 0, compressedSize);
    }

    public void uncompress(RegistryAccess registryAccess) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(this.payload.array());
        RegistryFriendlyByteBuf uncompressed = (RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)registryAccess).apply(new FriendlyByteBuf(Unpooled.buffer((int)(this.payload.readableBytes() * 4))));
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                uncompressed.writeBytes(buf, 0, count);
            }
            catch (Exception count) {}
        }
        int stacksSize = uncompressed.readInt();
        this.stacks = new ArrayList<ItemStack>(stacksSize);
        for (int i = 0; i < stacksSize; ++i) {
            ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)uncompressed);
            stack.setCount(uncompressed.readInt());
            this.stacks.add(stack);
        }
    }

    public void compress(RegistryAccess registryAccess) {
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        RegistryFriendlyByteBuf uncompressed = (RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)registryAccess).apply(new FriendlyByteBuf(Unpooled.buffer((int)(2048 * this.stacks.size()))));
        uncompressed.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)uncompressed, (Object)stack);
            uncompressed.writeInt(stack.getCount());
        }
        compressor.setInput(uncompressed.array(), 0, uncompressed.readableBytes());
        compressor.finish();
        this.payload = Unpooled.buffer((int)2048);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            this.payload.writeBytes(buf, 0, count);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

