/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.api.client.render.texture;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import tv.soaryn.xycraft.api.client.render.texture.IConnectedTextureHandler;
import tv.soaryn.xycraft.core.content.XyCraftTags;

public interface ConnectedTextureHandler {
    public static IConnectedTextureHandler isSameBlock() {
        return ConnectedTextureHandler.testingState((localState, neighborState) -> neighborState.is(localState.getBlock()));
    }

    public static IConnectedTextureHandler hasTag(TagKey<Block> tag) {
        return ConnectedTextureHandler.testingState((localState, neighborState) -> neighborState.is(tag));
    }

    public static IConnectedTextureHandler testingState(final BiPredicate<BlockState, BlockState> predicate) {
        return new IConnectedTextureHandler(){

            private boolean hasTagUncovered(BlockAndTintGetter level, BlockPos pos, BlockPos neighborPos, BlockState state, Direction face) {
                BlockState neighborState = level.getBlockState(neighborPos);
                BlockState stateAppearance = state.getAppearance(level, pos, face, neighborState, neighborPos);
                BlockState neighborAppearance = neighborState.getAppearance(level, neighborPos, face, state, pos);
                boolean a = !stateAppearance.isAir() && predicate.test(stateAppearance, neighborAppearance);
                BlockPos neighborRelative = neighborPos.relative(face);
                return a && (level.getBlockState(neighborRelative).is(XyCraftTags.Blocks.ConnectedTextureIgnoredOcclusion.tag()) || Block.shouldRenderFace((BlockState)neighborAppearance, (BlockGetter)level, (BlockPos)neighborPos, (Direction)face, (BlockPos)neighborRelative));
            }

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction side) {
                return this.hasTagUncovered(level, pos, pos.relative(side), state, face);
            }

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction corner1, Direction corner2) {
                return this.hasTagUncovered(level, pos, pos.relative(corner1).relative(corner2), state, face);
            }
        };
    }

    public static IConnectedTextureHandler fromBlock() {
        return new IConnectedTextureHandler(){

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction side) {
                Block block = state.getBlock();
                if (block instanceof IConnectedTextureHandler) {
                    IConnectedTextureHandler cth = (IConnectedTextureHandler)block;
                    return cth.shouldConnectTexture(level, pos, state, face, side);
                }
                throw new IllegalStateException("The block does not provide a connected texture handler.");
            }

            @Override
            public boolean shouldConnectTexture(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction face, Direction corner1, Direction corner2) {
                Block block = state.getBlock();
                if (block instanceof IConnectedTextureHandler) {
                    IConnectedTextureHandler cth = (IConnectedTextureHandler)block;
                    return cth.shouldConnectTexture(level, pos, state, face, corner1, corner2);
                }
                throw new IllegalStateException("The block does not provide a connected texture handler.");
            }
        };
    }
}

