/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container.resource;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.resource.IResourceContainer;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.utils.protocontainer.IResource;

public record ResourceContainerSlice<TResource extends IResource>(IResourceContainer<TResource> parent, int start, int length) implements IResourceContainer<TResource>
{
    @Override
    public int size() {
        return this.length;
    }

    @Override
    @NotNull
    public MutableResourceStack<TResource> get(int index) {
        Objects.checkIndex(index, this.length);
        return this.parent.get(index + this.start);
    }

    @Override
    public void set(int index, @Nonnull @NotNull MutableResourceStack<TResource> stack) {
        Objects.checkIndex(index, this.length);
        this.parent.set(index + this.start, stack);
    }

    @Override
    public boolean isValid(int index, @NotNull TResource stack) {
        Objects.checkIndex(index, this.length);
        return this.parent.isValid(index + this.start, stack);
    }

    @Override
    public int getCapacity(int index, @NotNull TResource resource) {
        return this.parent.getCapacity(index, resource);
    }

    @Override
    public int getCapacity(int index) {
        return this.parent.getCapacity(index);
    }

    @Override
    @NotNull
    public IResourceContainer<TResource> slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.length);
        return new ResourceContainerSlice<TResource>(this.parent, this.start + from, to - from);
    }

    @Override
    @NotNull
    public MutableResourceStack<TResource> defaultResource() {
        return this.parent.defaultResource();
    }
}

