/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.attachments.accessors;

import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.registries.CoreInput;
import tv.soaryn.xycraft.core.network.packets.SBModifierKeyPacket;
import tv.soaryn.xycraft.core.utils.Utils;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public interface ModifierKey {
    public static boolean of(Player player) {
        if (player == null) {
            return false;
        }
        return (Boolean)player.getData(CoreAttachments.ModifierKey);
    }

    public static boolean ofClient() {
        return ModifierKey.of(Utils.getClientPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onInputKey(InputEvent.Key event) {
        int action = event.getAction();
        if (action == 2) {
            return;
        }
        Player player = Utils.getClientPlayer();
        if (player == null) {
            return;
        }
        if (!CoreInput.ModifierKey.matches(event.getKey(), event.getScanCode())) {
            return;
        }
        boolean down = action == 1;
        player.setData(CoreAttachments.ModifierKey, (Object)down);
        XyCore.Network.send(new SBModifierKeyPacket(down));
    }
}

