/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks.prototype;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IGrowHandler;
import tv.soaryn.xycraft.core.content.blocks.prototype.GrowthType;
import tv.soaryn.xycraft.core.content.blocks.prototype.IGrowable;

@EventBusSubscriber(modid="xycraft_core", bus=EventBusSubscriber.Bus.MOD)
public class GrowableImplementations {
    public static final IGrowable ThreeTall = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            BlockState checkedBlock;
            int i;
            ObjectArraySet positions = new ObjectArraySet();
            int currentCount = 1;
            BlockPos.MutableBlockPos topPos = pos.mutable();
            BlockPos.MutableBlockPos bottomPos = pos.mutable();
            int maxHeight = 3;
            for (i = 1; i < maxHeight && currentCount < maxHeight && (checkedBlock = level.getBlockState((BlockPos)bottomPos.move(Direction.DOWN))).is(state.getBlock()); ++currentCount, ++i) {
            }
            for (i = 1; i < maxHeight && currentCount < maxHeight; ++currentCount, ++i) {
                checkedBlock = level.getBlockState((BlockPos)topPos.move(Direction.UP));
                if (checkedBlock.is(state.getBlock())) {
                    continue;
                }
                if (!checkedBlock.isAir()) {
                    return positions;
                }
                topPos.move(Direction.DOWN);
                break;
            }
            BlockPos finalPos = topPos.immutable();
            if (currentCount < maxHeight && (Integer)level.getBlockState(finalPos).getValue((Property)CactusBlock.AGE) <= 15) {
                positions.add((Object)finalPos);
            }
            return positions;
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.randomTick(level.getBlockState(blockPos), level, (BlockPos)blockPos));
            return positions;
        }

        public boolean randomTick(BlockState state, ServerLevel level, BlockPos pos) {
            BlockPos blockpos = pos.above();
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                int age = (Integer)state.getValue((Property)CactusBlock.AGE);
                if (age == 15) {
                    level.setBlockAndUpdate(blockpos, state.getBlock().defaultBlockState());
                    BlockState blockstate = (BlockState)state.setValue((Property)CactusBlock.AGE, (Comparable)Integer.valueOf(0));
                    level.setBlock(pos, blockstate, 4);
                    level.neighborChanged(blockstate, blockpos, state.getBlock(), pos, false);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CactusBlock.AGE, (Comparable)Integer.valueOf(age + 1)), 4);
                }
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
    };
    public static final IGrowable Crop = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            CropBlock cropBlock;
            Block block;
            ObjectArraySet positions = new ObjectArraySet();
            if (level.isAreaLoaded(pos, 1) && level.getRawBrightness(pos, 0) >= 9 && (block = state.getBlock()) instanceof CropBlock && !(cropBlock = (CropBlock)block).isMaxAge(state)) {
                positions.add((Object)pos);
            }
            return positions;
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.precheckedGrow(level.getBlockState(blockPos), level, (BlockPos)blockPos, randomSource, growthType));
            return positions;
        }

        public boolean precheckedGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randSource, GrowthType growthType) {
            CropBlock cropBlock = (CropBlock)state.getBlock();
            int age = cropBlock.getAge(state);
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || randSource.nextInt((int)(25.0f / 2.getGrowthSpeed(state, (Block)cropBlock, (BlockGetter)level, pos)) + 1) == 0 ? 1 : 0) != 0)) {
                level.setBlock(pos, cropBlock.getStateForAge(age + 1), 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }

        public static float getGrowthSpeed(BlockState state, Block block, BlockGetter level, BlockPos pos) {
            float speed = 1.0f;
            BlockPos blockpos = pos.below();
            for (int r = -1; r <= 1; ++r) {
                for (int c = -1; c <= 1; ++c) {
                    float soilModifier = 0.0f;
                    BlockState blockstate = level.getBlockState(blockpos.offset(r, 0, c));
                    if (!blockstate.canSustainPlant(level, blockpos.offset(r, 0, c), Direction.UP, state).isFalse()) {
                        soilModifier = 1.0f;
                        if (blockstate.isFertile(level, pos.offset(r, 0, c))) {
                            soilModifier = 3.0f;
                        }
                    }
                    if (r != 0 || c != 0) {
                        soilModifier /= 4.0f;
                    }
                    speed += soilModifier;
                }
            }
            BlockPos northPos = pos.north();
            BlockPos southPos = pos.south();
            BlockPos westPos = pos.west();
            BlockPos eastPos = pos.east();
            if (level.getBlockState(westPos).is(block) || level.getBlockState(eastPos).is(block) && level.getBlockState(northPos).is(block) || level.getBlockState(southPos).is(block) || level.getBlockState(westPos.north()).is(block) || level.getBlockState(eastPos.north()).is(block) || level.getBlockState(eastPos.south()).is(block) || level.getBlockState(westPos.south()).is(block)) {
                speed /= 2.0f;
            }
            return speed;
        }
    };
    public static final IGrowable NetherWart = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ObjectArraySet positions = new ObjectArraySet();
            if ((Integer)state.getValue((Property)NetherWartBlock.AGE) < 3) {
                positions.add((Object)pos);
            }
            return positions;
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> !this.precheckGrow(level.getBlockState(blockPos), level, (BlockPos)blockPos, randomSource, growthType));
            return positions;
        }

        public boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randSource, GrowthType growthType) {
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || randSource.nextInt(10) == 0 ? 1 : 0) != 0)) {
                BlockState newState = (BlockState)state.cycle((Property)NetherWartBlock.AGE);
                level.setBlock(pos, newState, 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)newState);
                return true;
            }
            return false;
        }
    };
    public static final IGrowable ChorusFruit = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ObjectArraySet positions = new ObjectArraySet();
            this.findFlowersRecusively(state, level, pos, Direction.DOWN, (ObjectArraySet<BlockPos>)positions);
            positions.removeIf(blockPos -> (Integer)level.getBlockState(blockPos).getValue((Property)ChorusFlowerBlock.AGE) == 5);
            return positions;
        }

        private void findFlowersRecusively(BlockState focusedState, LevelReader level, BlockPos pos, Direction prevDirection, ObjectArraySet<BlockPos> currentPositions) {
            BlockState state;
            BlockPos nextPos;
            if (focusedState.is(Blocks.CHORUS_FLOWER)) {
                currentPositions.add((Object)pos);
                return;
            }
            if (!focusedState.is(Blocks.CHORUS_PLANT)) {
                return;
            }
            if (((Boolean)focusedState.getValue((Property)ChorusPlantBlock.UP)).booleanValue()) {
                BlockPos nextPos2 = pos.above();
                BlockState state2 = level.getBlockState(nextPos2);
                this.findFlowersRecusively(state2, level, nextPos2, Direction.DOWN, currentPositions);
                return;
            }
            if (((Boolean)focusedState.getValue((Property)ChorusPlantBlock.EAST)).booleanValue() && prevDirection != Direction.EAST) {
                nextPos = pos.east();
                state = level.getBlockState(nextPos);
                this.findFlowersRecusively(state, level, nextPos, Direction.WEST, currentPositions);
            }
            if (((Boolean)focusedState.getValue((Property)ChorusPlantBlock.WEST)).booleanValue() && prevDirection != Direction.WEST) {
                nextPos = pos.west();
                state = level.getBlockState(nextPos);
                this.findFlowersRecusively(state, level, nextPos, Direction.EAST, currentPositions);
            }
            if (((Boolean)focusedState.getValue((Property)ChorusPlantBlock.NORTH)).booleanValue() && prevDirection != Direction.NORTH) {
                nextPos = pos.north();
                state = level.getBlockState(nextPos);
                this.findFlowersRecusively(state, level, nextPos, Direction.SOUTH, currentPositions);
            }
            if (((Boolean)focusedState.getValue((Property)ChorusPlantBlock.SOUTH)).booleanValue() && prevDirection != Direction.SOUTH) {
                nextPos = pos.south();
                state = level.getBlockState(nextPos);
                this.findFlowersRecusively(state, level, nextPos, Direction.NORTH, currentPositions);
            }
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPos -> {
                BlockState plantState = level.getBlockState(blockPos);
                return !plantState.isRandomlyTicking() || !this.precheckGrow(plantState, level, (BlockPos)blockPos, randomSource);
            });
            return positions;
        }

        private boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randSource) {
            state.randomTick(level, pos, randSource);
            return true;
        }
    };
    public static IGrowable GrowingPlantHead = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ObjectArraySet positions = new ObjectArraySet();
            Block block = state.getBlock();
            if (block instanceof GrowingPlantBlock) {
                GrowingPlantBlock growingPlantBlock = (GrowingPlantBlock)block;
            }
            return positions;
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            return this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
        }
    };
    public static final IGrowable CocoaBean = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            ObjectArraySet positions = new ObjectArraySet();
            if ((Integer)state.getValue((Property)CocoaBlock.AGE) < 2) {
                positions.add((Object)pos);
            }
            return positions;
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPosition -> !this.precheckGrow(level.getBlockState(blockPosition), level, (BlockPos)blockPosition, growthType));
            return positions;
        }

        private boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, GrowthType growthType) {
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || level.random.nextInt(5) == 0 ? 1 : 0) != 0)) {
                level.setBlock(pos, (BlockState)state.cycle((Property)CocoaBlock.AGE), 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
    };
    public static final IGrowable Bamboo = new IGrowable(){

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(BlockState state, LevelReader level, BlockPos pos, GrowthType growthType) {
            BlockState stalkState;
            int i;
            ObjectArraySet positions = new ObjectArraySet();
            Block plantBlock = state.getBlock();
            int currentCount = 0;
            BlockPos topPos = pos;
            for (i = 0; i < 16 && (stalkState = level.getBlockState(pos.above(i))).is(plantBlock); ++i) {
                topPos = pos.above(i);
                ++currentCount;
            }
            if ((Integer)level.getBlockState(topPos).getValue((Property)BambooStalkBlock.STAGE) != 0) {
                return positions;
            }
            if (currentCount >= 16) {
                return positions;
            }
            for (i = 1; i < 16 && (stalkState = level.getBlockState(pos.below(i))).is(plantBlock); ++i) {
                if (++currentCount < 16) continue;
                return positions;
            }
            BlockState topBlock = level.getBlockState(topPos);
            if (level.getBlockState(topPos.above()).isAir() && (Integer)topBlock.getValue((Property)BambooStalkBlock.STAGE) == 0 && level.getRawBrightness(topPos.above(), 0) >= 9) {
                positions.add((Object)topPos);
            }
            return positions;
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(state, (LevelReader)level, pos, growthType);
            positions.removeIf(blockPosition -> !this.precheckGrow(level.getBlockState(blockPosition), level, (BlockPos)blockPosition, randomSource, growthType));
            return positions;
        }

        private boolean precheckGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, GrowthType growthType) {
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (growthType == GrowthType.Deterministic || randomSource.nextInt(3) == 0 ? 1 : 0) != 0)) {
                int height = 0;
                while (level.getBlockState(pos.below(height + 1)).is(Blocks.BAMBOO)) {
                    ++height;
                }
                ++height;
                BlockPos posBelow1 = pos.below();
                BlockPos posBelow2 = pos.below(2);
                BlockState blockStateBelow = level.getBlockState(posBelow1);
                BlockState blockStateBelow2 = level.getBlockState(posBelow2);
                BambooLeaves bambooleaves = BambooLeaves.NONE;
                if (height >= 1) {
                    if (blockStateBelow.is(Blocks.BAMBOO) && blockStateBelow.getValue((Property)BambooStalkBlock.LEAVES) != BambooLeaves.NONE) {
                        bambooleaves = BambooLeaves.LARGE;
                        if (blockStateBelow2.is(Blocks.BAMBOO)) {
                            level.setBlock(posBelow1, (BlockState)blockStateBelow.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL), 3);
                            level.setBlock(posBelow2, (BlockState)blockStateBelow2.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.NONE), 3);
                        }
                    } else {
                        bambooleaves = BambooLeaves.SMALL;
                    }
                }
                int age = (Integer)state.getValue((Property)BambooStalkBlock.AGE) != 1 && !blockStateBelow2.is(Blocks.BAMBOO) ? 0 : 1;
                int stage = !(height >= 11 && randomSource.nextFloat() < 0.25f || height == 15) ? 0 : 1;
                level.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)Blocks.BAMBOO.defaultBlockState().setValue((Property)BambooStalkBlock.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)bambooleaves)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(stage)), 3);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
            return false;
        }
    };

    @SubscribeEvent
    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(IGrowHandler.BLOCK, (level, pos, state, blockEntity, context) -> VerticalGrowable.create(level, pos, state, 3, CactusBlock.AGE), new Block[]{Blocks.CACTUS});
        event.registerBlock(IGrowHandler.BLOCK, (level, pos, state, blockEntity, context) -> VerticalGrowable.create(level, pos, state, 3, SugarCaneBlock.AGE), new Block[]{Blocks.SUGAR_CANE});
    }

    private record VerticalGrowable(Level level, BlockPos pos, BlockState backingPlantState, int maxHeight, IntegerProperty ageProperty, int maxAge) implements IGrowHandler
    {
        public static VerticalGrowable create(Level level, BlockPos pos, BlockState backingPlantState, int maxHeight, IntegerProperty property) {
            return new VerticalGrowable(level, pos, backingPlantState, maxHeight, property, property.getPossibleValues().stream().mapToInt(Integer::intValue).max().orElse(1));
        }

        @Override
        @NotNull
        public Set<BlockPos> getBloomingPositions(GrowthType growthType) {
            BlockState checkedBlock;
            int i;
            BlockState state = this.level.getBlockState(this.pos);
            int currentCount = 1;
            BlockPos.MutableBlockPos topPos = this.pos.mutable();
            BlockPos.MutableBlockPos bottomPos = this.pos.mutable();
            for (i = 1; i < this.maxHeight && currentCount < this.maxHeight && (checkedBlock = this.level.getBlockState((BlockPos)bottomPos.move(Direction.DOWN))).is(state.getBlock()); ++currentCount, ++i) {
            }
            for (i = 1; i < this.maxHeight && currentCount < this.maxHeight; ++currentCount, ++i) {
                checkedBlock = this.level.getBlockState((BlockPos)topPos.move(Direction.UP));
                if (checkedBlock.is(state.getBlock())) {
                    continue;
                }
                if (!checkedBlock.isAir()) {
                    return Collections.emptySet();
                }
                topPos.move(Direction.DOWN);
                break;
            }
            BlockPos finalPos = topPos.immutable();
            if (currentCount < this.maxHeight && (Integer)this.level.getBlockState((BlockPos)topPos).getValue((Property)this.ageProperty) <= this.maxAge && CommonHooks.canCropGrow((Level)this.level, (BlockPos)finalPos, (BlockState)state, (boolean)true)) {
                return ObjectArraySet.of((Object)finalPos);
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<BlockPos> grow(GrowthType growthType, int growthCount) {
            Set<BlockPos> positions = this.getBloomingPositions(growthType);
            for (BlockPos plantPosition : positions) {
                BlockPos abovePlantPos = plantPosition.above(1);
                BlockState state = this.level.getBlockState(plantPosition);
                int age = (Integer)state.getValue((Property)this.ageProperty) + growthCount;
                if (age >= this.maxAge) {
                    BlockState fullPlant = this.backingPlantState.getBlock().defaultBlockState();
                    this.level.setBlockAndUpdate(abovePlantPos, fullPlant);
                    if (!fullPlant.canSurvive((LevelReader)this.level, abovePlantPos)) {
                        this.level.scheduleTick(abovePlantPos, this.backingPlantState.getBlock(), 1);
                    }
                    BlockState newLowerPlant = (BlockState)state.setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(0));
                    this.level.setBlock(plantPosition, newLowerPlant, 4);
                    this.level.neighborChanged(newLowerPlant, abovePlantPos, newLowerPlant.getBlock(), plantPosition, false);
                    CommonHooks.fireCropGrowPost((Level)this.level, (BlockPos)plantPosition, (BlockState)state);
                    continue;
                }
                this.level.setBlock(plantPosition, (BlockState)state.setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(age)), 4);
                CommonHooks.fireCropGrowPost((Level)this.level, (BlockPos)plantPosition, (BlockState)state);
                return Set.of();
            }
            return positions;
        }
    }
}

