/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.builder;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.RegistrationContentBuilder;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.datagen.BlockModelType;

public class BlockContentRegistrationBuilder
extends RegistrationContentBuilder<BlockContentRegistrationBuilder, BlockContent> {
    private Function<BlockBehaviour.Properties, BlockBehaviour.Properties> _blockProperties = Function.identity();
    private Supplier<Item.Properties> _itemProperties = Item.Properties::new;
    private final Function<BlockBehaviour.Properties, Block> _blockFactory;
    private Function<Block, Item> _itemBlockFactory = block -> new XyBlockItem((Block)block, this._itemProperties.get());
    private Function<Block, BlockEntityType<?>> _blockEntityFactory;
    private BlockModelType _model = BlockModelType.Simple;
    protected DeferredHolder<CreativeModeTab, CreativeModeTab> Tab;

    public BlockContentRegistrationBuilder(ContentMap map, String contentId, Function<BlockBehaviour.Properties, Block> factory) {
        super(map, contentId);
        this._blockFactory = factory;
    }

    public BlockContentRegistrationBuilder hidden() {
        this.Tab = null;
        return this;
    }

    public BlockContentRegistrationBuilder inTab(ContentMap map) {
        this.Tab = map.getTab();
        return this;
    }

    public BlockContentRegistrationBuilder inTab(@Nullable DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this.Tab = tab;
        return this;
    }

    public <T extends XyBlockEntity> BlockContentRegistrationBuilder withEntity(BlockEntityType.BlockEntitySupplier<T> factory) {
        return this.withEntity((Block blockRef) -> XyBlockEntity.supplier(factory, blockRef));
    }

    public BlockContentRegistrationBuilder withEntity(Function<Block, BlockEntityType<?>> factory) {
        this._blockEntityFactory = factory;
        return this;
    }

    public BlockContentRegistrationBuilder withBlockProperties(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> properties) {
        this._blockProperties = properties;
        return this;
    }

    public BlockContentRegistrationBuilder copyPropertiesFrom(Supplier<Block> backingBlock) {
        this._blockProperties = properties -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)backingBlock.get()));
        return this;
    }

    public BlockContentRegistrationBuilder withItemProperties(Supplier<Item.Properties> itemProperties) {
        this._itemProperties = itemProperties;
        return this;
    }

    public BlockContentRegistrationBuilder withItem(Function<Block, Item> item) {
        this._itemBlockFactory = item;
        return this;
    }

    public BlockContentRegistrationBuilder withModelType(BlockModelType model) {
        this._model = model;
        return this;
    }

    @Override
    public BlockContent build() {
        DeferredBlock registryBlock = this._map.BlockMap.register(this.Id, () -> this._blockFactory.apply(this._blockProperties.apply(BlockBehaviour.Properties.of())));
        DeferredItem registryItem = this._map.ItemMap.register(this.Id, () -> this._itemBlockFactory.apply((Block)registryBlock.get()));
        DeferredHolder registryEntity = null;
        if (this._blockEntityFactory != null) {
            registryEntity = this._map.BlockEntityMap.register(this.Id, () -> this._blockEntityFactory.apply((Block)registryBlock.get()));
        }
        BlockContent content = new BlockContent((DeferredBlock<Block>)registryBlock, (DeferredItem<Item>)registryItem, registryEntity);
        this._map.ListOfBlocks.add(content);
        this._map.MappedContent.add(content);
        content.setTab((DeferredHolder)this.Tab);
        content.withModelType(this._model);
        content.requires(this._requirement);
        this._localizations.forEach((mcLocale, name) -> content.withName(mcLocale.toString(), (String)name));
        return content;
    }
}

