/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.network.packets;

import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.ui.slots.GhostSlot;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;

public record SBGhostSlotClickPacket(int slot, boolean setCarried, boolean strict) implements Packet.ServerBound
{
    public static final BinarySerializer<SBGhostSlotClickPacket> SerDes = BinarySerializer.ofType(SBGhostSlotClickPacket::new, SBGhostSlotClickPacket::slot, Serializer.INTEGER, SBGhostSlotClickPacket::setCarried, Serializer.BOOLEAN, SBGhostSlotClickPacket::strict, Serializer.BOOLEAN);

    @Override
    public void handle(Packet.ServerBound.Context context) {
        context.enqueueMainThread(() -> {
            AbstractContainerMenu menu = context.player().containerMenu;
            Slot slot = (Slot)menu.slots.get(this.slot());
            if (slot instanceof GhostSlot) {
                GhostSlot ghostSlot = (GhostSlot)slot;
                if (this.setCarried()) {
                    ItemStack carried = menu.getCarried();
                    ItemStack newItem = carried.copy();
                    newItem.setCount(Math.min(newItem.getCount(), slot.getMaxStackSize(carried)));
                    slot.set(newItem);
                }
                ghostSlot.setStrictInternal(this.strict());
                slot.setChanged();
            }
        });
    }
}

