/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui.widgets.drawable;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widgets.DrawableWidget;
import tv.soaryn.xycraft.core.ui.widgets.MutableRectangle;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class DrawableImage
extends DrawableWidget<DrawableImage> {
    private ResourceLocation _texture = XyCore.resource("textures/gui/always_on.png");
    private final MutableRectangle _padding = new MutableRectangle(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean _tiled = false;
    private int textureWidth = 16;
    private int textureHeight = 16;

    private DrawableImage() {
    }

    public static DrawableImage create() {
        return new DrawableImage();
    }

    public DrawableImage texture(ResourceLocation resource) {
        this._texture = resource;
        return this;
    }

    public DrawableImage setScale(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    public DrawableImage texture(ResourceLocation resource, boolean isTiled) {
        this._tiled = isTiled;
        return this.texture(resource);
    }

    public DrawableImage padding(float x, float y, float width, float height) {
        this._padding.x = x;
        this._padding.y = y;
        this._padding.width = width;
        this._padding.height = height;
        return this;
    }

    @Override
    public void drawWidget(GuiGraphics graphics, float x, float y, double mouseX, double mouseY, int depth) {
        RenderSystem.enableBlend();
        Vector4f rgba = ColorUtils.convertToRGBAVec(this.Color);
        graphics.setColor(rgba.x, rgba.y, rgba.z, rgba.w);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._texture);
        if (!this._tiled) {
            TiledIcon.innerBlit(graphics, x + this.Dimensions.x + this._padding.x, x + this.Dimensions.x + this.Dimensions.width + this._padding.width, y + this.Dimensions.y + this._padding.y, y + this.Dimensions.y + this.Dimensions.height + this._padding.height, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        } else {
            TiledIcon.render(graphics.pose(), x, y, this.Dimensions.width, this.Dimensions.height, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.textureWidth, this.textureHeight, new TiledIcon.TileConfiguration(true, this.Dimensions.width, this.Dimensions.height));
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

