/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import tv.soaryn.xycraft.core.content.attachments.memory.FastVolumeMemoryLevelAttachment;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;

public final class FastVolumeLookup<T> {
    private final Long2ObjectMap<ChunkVolumeData<T>> chunkVolumeData = new Long2ObjectOpenHashMap();
    private final Reference2ObjectMap<T, Pair<ChunkPos, ChunkPos>> values = new Reference2ObjectOpenHashMap();
    private final Set<T> valuesView = Collections.unmodifiableSet(this.values.keySet());

    public static <T> FastVolumeLookup<T> of(Level level, Class<T> type) {
        return ((FastVolumeMemoryLevelAttachment)level.getData(CoreAttachments.FastVolumeLookUp)).getLookup(type);
    }

    public void add(T value, BlockPos corner1, BlockPos corner2) {
        BlockPos minPos = new BlockPos(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ()));
        BlockPos maxPos = new BlockPos(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ()));
        ChunkPos minChunkPos = new ChunkPos(minPos);
        ChunkPos maxChunkPos = new ChunkPos(maxPos);
        for (int x = minChunkPos.x; x <= maxChunkPos.x; ++x) {
            for (int z = minChunkPos.z; z <= maxChunkPos.z; ++z) {
                long longChunkPos = ChunkPos.asLong((int)x, (int)z);
                ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.computeIfAbsent(longChunkPos, $ -> new ChunkVolumeData());
                volumeData.add(minPos, maxPos, value);
            }
        }
        this.values.put(value, (Object)Pair.of((Object)minChunkPos, (Object)maxChunkPos));
    }

    public ChunkVolumeData<T> getVolumesForChunk(long chunk) {
        return (ChunkVolumeData)this.chunkVolumeData.get(chunk);
    }

    public void remove(T value) {
        Pair chunkPositions = (Pair)this.values.remove(value);
        if (chunkPositions == null) {
            return;
        }
        ChunkPos minChunkPos = (ChunkPos)chunkPositions.getLeft();
        ChunkPos maxChunkPos = (ChunkPos)chunkPositions.getRight();
        for (int x = minChunkPos.x; x <= maxChunkPos.x; ++x) {
            for (int z = minChunkPos.z; z <= maxChunkPos.z; ++z) {
                long longChunkPos = ChunkPos.asLong((int)x, (int)z);
                ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.get(longChunkPos);
                if (volumeData == null) continue;
                volumeData.remove(value);
            }
        }
    }

    public Stream<T> find(BlockPos pos) {
        long longChunkPos = ChunkPos.asLong((BlockPos)pos);
        ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.get(longChunkPos);
        if (volumeData == null) {
            return Stream.empty();
        }
        return volumeData.find(pos);
    }

    public Stream<T> findThreaded(BlockPos pos) {
        long longChunkPos = ChunkPos.asLong((BlockPos)pos);
        ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.get(longChunkPos);
        if (volumeData == null) {
            return Stream.empty();
        }
        return volumeData.findThreaded(pos);
    }

    public Stream<BlockPos> getAllBoxes(BlockPos pos) {
        long longChunkPos = ChunkPos.asLong((BlockPos)pos);
        ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.get(longChunkPos);
        if (volumeData == null) {
            return Stream.empty();
        }
        return volumeData.findBoxes(pos);
    }

    public Set<T> getAll() {
        return this.valuesView;
    }

    public static class ChunkVolumeData<T> {
        private final Reference2ObjectMap<T, Pair<BlockPos, BlockPos>> values = new Reference2ObjectOpenHashMap();

        private void add(BlockPos min, BlockPos max, T value) {
            this.values.put(value, (Object)Pair.of((Object)min, (Object)max));
        }

        private void remove(T value) {
            this.values.remove(value);
        }

        public Stream<T> findThreaded(BlockPos pos) {
            return this.values.entrySet().stream().filter(entry -> {
                BlockPos min = (BlockPos)((Pair)entry.getValue()).getLeft();
                BlockPos max = (BlockPos)((Pair)entry.getValue()).getRight();
                return pos.getX() >= min.getX() && pos.getX() <= max.getX() && pos.getY() >= min.getY() && pos.getY() <= max.getY() && pos.getZ() >= min.getZ() && pos.getZ() <= max.getZ();
            }).map(Map.Entry::getKey);
        }

        public Stream<T> find(BlockPos pos) {
            return this.values.entrySet().stream().filter(entry -> {
                BlockPos min = (BlockPos)((Pair)entry.getValue()).getLeft();
                BlockPos max = (BlockPos)((Pair)entry.getValue()).getRight();
                return pos.getX() >= min.getX() && pos.getX() <= max.getX() && pos.getY() >= min.getY() && pos.getY() <= max.getY() && pos.getZ() >= min.getZ() && pos.getZ() <= max.getZ();
            }).map(Map.Entry::getKey);
        }

        public Stream<BlockPos> findBoxes(BlockPos pos) {
            return this.values.values().stream().filter(blockPosBlockPosPair -> {
                BlockPos min = (BlockPos)blockPosBlockPosPair.getLeft();
                BlockPos max = (BlockPos)blockPosBlockPosPair.getRight();
                return pos.getX() >= min.getX() && pos.getX() <= max.getX() && pos.getY() >= min.getY() && pos.getY() <= max.getY() && pos.getZ() >= min.getZ() && pos.getZ() <= max.getZ();
            }).flatMap(blockPosBlockPosPair -> BlockPos.betweenClosedStream((BlockPos)((BlockPos)blockPosBlockPosPair.getLeft()), (BlockPos)((BlockPos)blockPosBlockPosPair.getRight())).map(BlockPos::immutable));
        }

        public Stream<T> getAll() {
            return this.values.keySet().stream();
        }

        public Map<T, Pair<BlockPos, BlockPos>> getMap() {
            return Collections.unmodifiableMap(this.values);
        }
    }
}

