/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.handlers;

import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class InfiniteFluidHandler
implements IFluidHandler {
    private FluidStack _selected = FluidStack.EMPTY;

    public InfiniteFluidHandler() {
    }

    public InfiniteFluidHandler(Fluid fluid) {
        this._selected = new FluidStack(fluid, 1000000000);
    }

    public FluidStack getSelected() {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this._selected.copy();
    }

    public boolean setSelected(FluidStack stack) {
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this._selected, (FluidStack)stack)) {
            this._selected = stack.copy();
            return true;
        }
        return false;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this._selected.copyWithAmount(1000000000);
    }

    public int getTankCapacity(int tank) {
        return 1000000000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this._selected) ? resource.copy() : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        if (this._selected.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this._selected.copyWithAmount(maxDrain);
    }
}

