/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.containers.PocketGeneratorContainer;
import com.direwolf20.justdirethings.common.items.FuelCanister;
import com.direwolf20.justdirethings.common.items.PocketGenerator;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PocketGeneratorScreen
extends AbstractContainerScreen<PocketGeneratorContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/pocketgenerator.png");
    protected final PocketGeneratorContainer container;
    private ItemStack pocketGenerator;
    private IEnergyStorage energyStorage;

    public PocketGeneratorScreen(PocketGeneratorContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.pocketGenerator = container.playerEntity.getMainHandItem();
        this.energyStorage = (IEnergyStorage)this.pocketGenerator.getCapability(Capabilities.EnergyStorage.ITEM);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (mouseX > this.leftPos + 7 && mouseX < this.leftPos + 7 + 18 && mouseY > this.topPos + 7 && mouseY < this.topPos + 7 + 73) {
            int counter = (Integer)this.pocketGenerator.getOrDefault(JustDireDataComponents.POCKETGEN_COUNTER, (Object)0);
            int feBurnPerTick = 0;
            Item item = this.pocketGenerator.getItem();
            if (item instanceof PocketGenerator) {
                PocketGenerator pocketGeneratorItem = (PocketGenerator)item;
                feBurnPerTick = pocketGeneratorItem.getFePerFuelTick() * pocketGeneratorItem.getBurnSpeedMultiplier(this.pocketGenerator);
            }
            if (PocketGeneratorScreen.hasShiftDown()) {
                guiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.formatted(this.energyStorage.getEnergyStored()), MagicHelpers.withSuffix(this.energyStorage.getMaxEnergyStored())}), counter <= 0 ? Component.translatable((String)"justdirethings.screen.no_fuel") : Component.translatable((String)"justdirethings.screen.burn_time", (Object[])new Object[]{MagicHelpers.ticksInSeconds(counter)}), counter > 0 ? Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(feBurnPerTick)}) : Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(0)}))), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.withSuffix(this.energyStorage.getEnergyStored()), MagicHelpers.withSuffix(this.energyStorage.getMaxEnergyStored())}), counter <= 0 ? Component.translatable((String)"justdirethings.screen.no_fuel") : Component.translatable((String)"justdirethings.screen.burn_time", (Object[])new Object[]{MagicHelpers.ticksInSeconds(counter)}), counter > 0 ? Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(feBurnPerTick)}) : Component.translatable((String)"justdirethings.screen.fepertick", (Object[])new Object[]{MagicHelpers.formatted(0)}))), mouseX, mouseY);
            }
        }
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        ItemStack fuelStack;
        int burnTime;
        if (((PocketGeneratorContainer)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem() && (burnTime = (fuelStack = this.hoveredSlot.getItem()).getBurnTime(RecipeType.SMELTING)) > 0) {
            int fuelBurnMultiplier = 1;
            Item item = fuelStack.getItem();
            if (item instanceof Coal_T1) {
                Coal_T1 direCoal = (Coal_T1)item;
                fuelBurnMultiplier = direCoal.getBurnSpeedMultiplier();
            } else {
                BlockItem blockItem;
                item = fuelStack.getItem();
                if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CoalBlock_T1) {
                    CoalBlock_T1 coalBlock = (CoalBlock_T1)item;
                    fuelBurnMultiplier = coalBlock.getBurnSpeedMultiplier();
                } else if (fuelStack.getItem() instanceof FuelCanister) {
                    fuelBurnMultiplier = FuelCanister.getBurnSpeedMultiplier(fuelStack);
                }
            }
            List tooltip = this.getTooltipFromContainerItem(fuelStack);
            tooltip.add(Component.translatable((String)"justdirethings.screen.burnspeedmultiplier", (Object[])new Object[]{fuelBurnMultiplier}).withStyle(ChatFormatting.RED));
            pGuiGraphics.renderTooltip(this.font, tooltip, fuelStack.getTooltipImage(), fuelStack, pX, pY);
            return;
        }
        super.renderTooltip(pGuiGraphics, pX, pY);
    }

    protected void renderSlot(GuiGraphics pGuiGraphics, Slot pSlot) {
        super.renderSlot(pGuiGraphics, pSlot);
    }

    public void init() {
        super.init();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        this.pocketGenerator = this.container.playerEntity.getMainHandItem();
        if (this.pocketGenerator.isEmpty() || !(this.pocketGenerator.getItem() instanceof PocketGenerator)) {
            return;
        }
        this.energyStorage = (IEnergyStorage)this.pocketGenerator.getCapability(Capabilities.EnergyStorage.ITEM);
        if (this.energyStorage == null) {
            return;
        }
        int maxBurn = (Integer)this.pocketGenerator.getOrDefault(JustDireDataComponents.POCKETGEN_MAXBURN, (Object)0);
        int counter = (Integer)this.pocketGenerator.getOrDefault(JustDireDataComponents.POCKETGEN_COUNTER, (Object)0);
        int maxHeight = 13;
        if (maxBurn > 0) {
            int remaining = counter * maxHeight / maxBurn;
            guiGraphics.blit(this.GUI, this.leftPos + 80, this.topPos + 17 + 13 - remaining, 176, 13 - remaining, 14, remaining + 1);
        }
        int maxEnergy = this.energyStorage.getMaxEnergyStored();
        int height = 70;
        if (maxEnergy > 0) {
            int remaining = this.energyStorage.getEnergyStored() * height / maxEnergy;
            guiGraphics.blit(this.GUI, this.leftPos + 8, this.topPos + 78 - remaining, 176, 84 - remaining, 16, remaining + 1);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        return super.mouseClicked(x, y, btn);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        return super.mouseScrolled(mouseX, mouseY, pScrollX, pScrollY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("justdirethings." + key), (Object[])args);
    }
}

