/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.registry.SFMTextEditors;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.text_editor.ISFMTextEditScreen;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMClientTextEditorConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SFMTextEditorConfigScreen
extends Screen {
    private final SFMClientTextEditorConfig config;
    private final ISFMTextEditScreen parent;
    private final Runnable closeCallback;
    private Button lineNumbersOnButton;
    private Button lineNumbersOffButton;
    private Button intellisenseOffButton;
    private Button intellisenseBasicButton;
    private Button intellisenseAdvancedButton;
    private Button preferredEditorV1Button;
    private Button preferredEditorV2Button;
    private final boolean editorSelectorFeatureFlag = SFMEnvironmentUtils.isInIDE();

    public SFMTextEditorConfigScreen(ISFMTextEditScreen parent, SFMClientTextEditorConfig config, Runnable closeCallback) {
        super((Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_SCREEN_TITLE.getComponent());
        this.config = config;
        this.parent = parent;
        this.closeCallback = closeCallback;
    }

    public void onClose() {
        SFMScreenChangeHelpers.popScreen();
        this.closeCallback.run();
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        int y = this.height / 2 - 65;
        int x = this.width / 2 - 150;
        graphics.drawString(this.font, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_LINE_NUMBERS.getComponent(), x, y, 0xFFFFFF);
        graphics.drawString(this.font, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE.getComponent(), x, y + 50, 0xFFFFFF);
        if (this.editorSelectorFeatureFlag) {
            graphics.drawString(this.font, (Component)LocalizationKeys.PROGRAM_EDITOR_CONFIG_PREFERRED_EDITOR.getComponent(), x, y + 100, 0xFFFFFF);
        }
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
    }

    protected void init() {
        super.init();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int x = this.width / 2 - 3 * buttonWidth / 2 - 10;
        int y = this.height / 2 - 50;
        int spacing = 50;
        int buttonSpacing = 10;
        this.lineNumbersOnButton = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y).setSize(buttonWidth, buttonHeight).setText(CommonComponents.OPTION_ON).setOnPress(button -> {
            this.config.showLineNumbers.set((Object)true);
            this.updateButtonStates();
        }).build();
        this.lineNumbersOffButton = new SFMButtonBuilder().setPosition(x, y).setSize(buttonWidth, buttonHeight).setText(CommonComponents.OPTION_OFF).setOnPress(button -> {
            this.config.showLineNumbers.set((Object)false);
            this.updateButtonStates();
        }).build();
        this.addRenderableWidget((GuiEventListener)this.lineNumbersOnButton);
        this.addRenderableWidget((GuiEventListener)this.lineNumbersOffButton);
        this.intellisenseOffButton = new SFMButtonBuilder().setPosition(x, y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_OFF).setOnPress(button -> {
            this.config.intellisenseLevel.set((Object)SFMTextEditorIntellisenseLevel.OFF);
            this.updateButtonStates();
            this.parent.onPreferenceChanged();
        }).build();
        this.intellisenseBasicButton = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_BASIC).setOnPress(button -> {
            this.config.intellisenseLevel.set((Object)SFMTextEditorIntellisenseLevel.BASIC);
            this.updateButtonStates();
            this.parent.onPreferenceChanged();
        }).build();
        this.intellisenseAdvancedButton = new SFMButtonBuilder().setPosition(x + 2 * (buttonWidth + buttonSpacing), y + spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_INTELLISENSE_ADVANCED).setOnPress(button -> {
            this.config.intellisenseLevel.set((Object)SFMTextEditorIntellisenseLevel.ADVANCED);
            this.updateButtonStates();
            this.parent.onPreferenceChanged();
        }).build();
        this.addRenderableWidget((GuiEventListener)this.intellisenseOffButton);
        this.addRenderableWidget((GuiEventListener)this.intellisenseBasicButton);
        this.addRenderableWidget((GuiEventListener)this.intellisenseAdvancedButton);
        this.preferredEditorV1Button = new SFMButtonBuilder().setPosition(x, y + 2 * spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_PREFERRED_EDITOR_V1).setOnPress(button -> {
            this.config.preferredEditor.set((Object)SFMTextEditors.V1.getKey().location().toString());
            this.updateButtonStates();
        }).build();
        this.preferredEditorV2Button = new SFMButtonBuilder().setPosition(x + buttonWidth + buttonSpacing, y + 2 * spacing).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.PROGRAM_EDITOR_CONFIG_PREFERRED_EDITOR_V2).setOnPress(button -> {
            this.config.preferredEditor.set((Object)SFMTextEditors.V2.getKey().location().toString());
            this.updateButtonStates();
        }).build();
        if (this.editorSelectorFeatureFlag) {
            this.addRenderableWidget((GuiEventListener)this.preferredEditorV1Button);
            this.addRenderableWidget((GuiEventListener)this.preferredEditorV2Button);
        }
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 100, this.height - 50).setSize(200, 20).setText(CommonComponents.GUI_DONE).setOnPress(button -> this.onClose()).build());
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.lineNumbersOnButton.active = (Boolean)this.config.showLineNumbers.get() == false;
        this.lineNumbersOffButton.active = (Boolean)this.config.showLineNumbers.get();
        this.intellisenseOffButton.active = this.config.intellisenseLevel.get() != SFMTextEditorIntellisenseLevel.OFF;
        this.intellisenseBasicButton.active = this.config.intellisenseLevel.get() != SFMTextEditorIntellisenseLevel.BASIC;
        this.intellisenseAdvancedButton.active = this.config.intellisenseLevel.get() != SFMTextEditorIntellisenseLevel.ADVANCED;
        String currentEditor = (String)this.config.preferredEditor.get();
        this.preferredEditorV1Button.active = !currentEditor.equals(SFMTextEditors.V1.getKey().location().toString());
        this.preferredEditorV2Button.active = !currentEditor.equals(SFMTextEditors.V2.getKey().location().toString());
    }
}

