/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;

public final class LongestCommonSubstring
implements StringMetric,
StringDistance {
    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return (float)LongestCommonSubstring.lcs(a, b) / (float)Math.max(a.length(), b.length());
    }

    @Override
    public float distance(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 0.0f;
        }
        if (a.isEmpty()) {
            return b.length();
        }
        if (b.isEmpty()) {
            return a.length();
        }
        return a.length() + b.length() - 2 * LongestCommonSubstring.lcs(a, b);
    }

    private static int lcs(String a, String b) {
        int m = a.length();
        int n = b.length();
        int[] v0 = new int[n];
        int[] v1 = new int[n];
        int z = 0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (a.charAt(i) == b.charAt(j)) {
                    v1[j] = i == 0 || j == 0 ? 1 : v0[j - 1] + 1;
                    if (v1[j] <= z) continue;
                    z = v1[j];
                    continue;
                }
                v1[j] = 0;
            }
            int[] swap = v0;
            v0 = v1;
            v1 = swap;
        }
        return z;
    }

    public String toString() {
        return "LongestCommonSubstring";
    }
}

